/*
 *    paperease: a driver for the Primax Paperease scanner
 *    (c) 2002 James McKenzie <james@fishsoup.dhs.org>. 
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License , or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program. If not, write to the Free Software
 *    Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *    This program was produced by running the windows drivers
 *    for the program and recording all accesses to the parallel
 *    port circuitry passing the results through awk, sed and uniq.
 *
 *    Take care not to quit this program except by using 
 *    SIGINT - doing do may burn out the motor on your 
 *    scanner.
 *
 */
/*
 * io.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] = "$Id: io.c,v 1.18 2002/05/19 15:56:36 root Exp $";

/*
 * $Log: io.c,v $
 * Revision 1.18  2002/05/19 15:56:36  root
 * *** empty log message ***
 *
 * Revision 1.17  2002/05/19 15:21:05  root
 * *** empty log message ***
 *
 * Revision 1.16  2002/05/19 15:20:59  root
 * *** empty log message ***
 *
 * Revision 1.15  2002/05/19 10:50:06  root
 * *** empty log message ***
 *
 * Revision 1.14  2002/05/18 16:52:48  root
 * *** empty log message ***
 *
 * Revision 1.13  2002/05/18 16:52:44  root
 * *** empty log message ***
 *
 * Revision 1.12  2002/05/18 16:52:41  root
 * *** empty log message ***
 *
 * Revision 1.11  2002/05/18 16:52:39  root
 * *** empty log message ***
 *
 * Revision 1.10  2002/05/18 16:33:42  root
 * *** empty log message ***
 *
 * Revision 1.9  2002/05/18 16:33:26  root
 * *** empty log message ***
 *
 * Revision 1.8  2002/05/18 15:30:13  root
 * *** empty log message ***
 *
 * Revision 1.7  2002/05/18 15:30:10  root
 * *** empty log message ***
 *
 * Revision 1.6  2002/05/18 13:55:25  root
 * *** empty log message ***
 *
 * Revision 1.5  2002/05/18 11:25:40  root
 * *** empty log message ***
 *
 * Revision 1.4  2002/05/18 10:37:47  root
 * *** empty log message ***
 *
 * Revision 1.3  2002/05/18 10:34:19  root
 * *** empty log message ***
 *
 * Revision 1.2  2002/05/18 10:34:09  root
 * *** empty log message ***
 *
 * Revision 1.1  2002/05/18 10:33:47  root
 * Initial revision
 *
 */

#include "project.h"

int port = 0x378;


void doublec()
{
  int v = IN(port);
  OUT(v & 0x7f, port);
  OUT(v | 0x80, port);
  OUT(v & 0x7f, port);
  OUT(v | 0x80, port);
}

int scanner_read(void)
{
  int h, l;
  OUT(0xdf, port);
  l = IN(port + 1) & 0x78;
  OUT(0xff, port);
  h = IN(port + 1) & 0x78;
  h <<= 1;
  h |= (l >> 3);
  return h;
}

void scanner_write(int v)
{
  int l = v & 0xf;
  int h = v >> 4;

  OUT(0xf0 | l, port);
  OUT(0xe0 | l, port);
  OUT(0xc0 | l, port);
  OUT(0xe0 | l, port);
  OUT(0xe0 | h, port);
  OUT(0xc0 | h, port);
  OUT(0xe0 | h, port);
  OUT(0xf0 | h, port);
}


void scanner_write_oob(int v)
{
  OUT(0xe0 | v, port);
  OUT(0xa0 | v, port);
  OUT(0xe0 | v, port);
  OUT(0xf0 | v, port);
}

void scanner_write_oob_reset(int v)
{
  OUT(0xe0 | v, port);
  OUT(0xa0 | v, port);
  OUT(0xe0 | v, port);
  OUT(0xff, port);
}


void scanner_write_upcounting_256(void)
{
  int i;
  for (i = 0; i < 0x100; ++i) {
    scanner_write(i);
  }
}

int scanner_read_upcounting_256(void)
{
  int i, j;
  for (i = 0; i < 0x100; ++i) {
    j = scanner_read();
    if (j != i)
      printf("scanner_read_upcounting_256: scanner_read %x expected %x\n",
             j, i);
  }
}

int scanner_read_noisy(char *file, int line, char *func)
{
  int r = scanner_read();
  printf("%s: %d: %s: %x\n", file, line, func, r);
  return r;
}

init_port(void)
{
  int i;

  iopl(3);

#define ECR_NERRINTREN          0x10
#define ECR_SERVICEINTR         0x04
#define ECR_MODE_EPP            0x20

  outb(ECR_NERRINTREN | ECR_SERVICEINTR | ECR_MODE_EPP, port + 0x402);
}
