/*
 *    paperease: a driver for the Primax Paperease scanner
 *    (c) 2002 James McKenzie <james@fishsoup.dhs.org>. 
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License , or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program. If not, write to the Free Software
 *    Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *    This program was produced by running the windows drivers
 *    for the program and recording all accesses to the parallel
 *    port circuitry passing the results through awk, sed and uniq.
 *
 *    Take care not to quit this program except by using 
 *    SIGINT - doing do may burn out the motor on your 
 *    scanner.
 *
 */
/*
 * main.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] = "$Id: main.c,v 1.20 2002/05/19 15:56:36 root Exp $";


/*
 * $Log: main.c,v $
 * Revision 1.20  2002/05/19 15:56:36  root
 * *** empty log message ***
 *
 * Revision 1.19  2002/05/19 15:21:05  root
 * *** empty log message ***
 *
 * Revision 1.18  2002/05/19 15:20:59  root
 * *** empty log message ***
 *
 * Revision 1.17  2002/05/19 10:50:06  root
 * *** empty log message ***
 *
 * Revision 1.16  2002/05/18 16:52:48  root
 * *** empty log message ***
 *
 * Revision 1.15  2002/05/18 16:52:44  root
 * *** empty log message ***
 *
 * Revision 1.14  2002/05/18 16:52:41  root
 * *** empty log message ***
 *
 * Revision 1.13  2002/05/18 16:52:39  root
 * *** empty log message ***
 *
 * Revision 1.12  2002/05/18 16:33:47  root
 * *** empty log message ***
 *
 * Revision 1.11  2002/05/18 16:33:42  root
 * *** empty log message ***
 *
 * Revision 1.10  2002/05/18 16:33:26  root
 * *** empty log message ***
 *
 * Revision 1.9  2002/05/18 15:30:13  root
 * *** empty log message ***
 *
 * Revision 1.8  2002/05/18 15:30:10  root
 * *** empty log message ***
 *
 * Revision 1.7  2002/05/18 14:40:49  root
 * *** empty log message ***
 *
 * Revision 1.6  2002/05/18 13:55:25  root
 * *** empty log message ***
 *
 * Revision 1.5  2002/05/18 11:25:40  root
 * *** empty log message ***
 *
 * Revision 1.4  2002/05/18 10:37:47  root
 * *** empty log message ***
 *
 * Revision 1.3  2002/05/18 10:34:19  root
 * *** empty log message ***
 *
 * Revision 1.2  2002/05/18 10:34:09  root
 * *** empty log message ***
 *
 * Revision 1.1  2002/05/18 10:33:47  root
 * Initial revision
 *
 */

#include "project.h"


#define OBWIDTH 317
#define WIDTH 2548
#define BLANKS 20

unsigned char flip_byte[0x100];

int quitme = 0;

void sigint(int dummy)
{
  quitme++;
}

abort_scan()
{
  printf("Aborting scan...\n");
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_read() /*==0x60*/ ;
  SHORTSLEEP;
  scanner_write_oob_reset(0xb);
  scanner_read() /*==0xca*/ ;
  SHORTSLEEP;
  scanner_write_oob_reset(0x4);
  scanner_write(0x00);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  scanner_write(0x0f);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write(0x00);

  while (1) {
    scanner_write_oob_reset(0x0);
    if (scanner_read() & 2)
      break;
    SCHEDULINGSLEEP;
  }

  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  scanner_write(0x0f);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write(0x00);
  SHORTSLEEP;
  sleepdown();


}

int scan_pages(char *base, int grey)
{
  int i, j, k, l, m, h;
  FILE *f;
  long off;
  int e;
  int stayin;
  int page = 1;
  char filename[1024];

  do {
    if (grey)
      start_eightbit();
    else
      start_onebit();

    //Feed sheet into bottom part of scanner

    stayin = 1;
    while (stayin) {
      scanner_write_oob_reset(0x0);
      j = scanner_read();
      SHORTSLEEP;
      scanner_write_oob_reset(0xb);
      k = scanner_read();

      switch (j) {
      case 0x32:
        //not there yet
        break;
      case 0x60:
      case 0x70:
        //ok jump out
        stayin = 0;
        break;
      case 0xb2:
        //paper jam
        printf("Paper jam\n");
        exit(1);
        break;
      default:

      }
      SCHEDULINGSLEEP;
    }
    printf("Step 1: %x %x\n", j, k);

//Now look for the paper hitting the CCD.


    while (1) {
      scanner_write_oob(0x1);
      j = scanner_read();
      SHORTSLEEP;
      scanner_write_oob(0x4);
      k = scanner_read();
      MOTORSLEEP;

      if (k > 0x98)
        break;

      scanner_write_oob_reset(0x0);
      l = scanner_read();
      SHORTSLEEP;
      scanner_write_oob_reset(0xb);
      m = scanner_read();

    }

    printf("Step 2: %2x %2x %2x %2x\n", j, k, l, m);



    sprintf(filename, base, page++);

    f = fopen(filename, "w");

    fprintf(f, "P%d\n", grey ? 5 : 4);
    off = ftell(f);
    fprintf(f, "%8d %8d\n", grey ? WIDTH : (OBWIDTH * 8), 0);
    if (grey)
      fprintf(f, "255\n");


    h = 0;
    while (1) {
      unsigned char buf[WIDTH];

      scanner_write_oob(0x2);

      if (grey) {
        for (i = 1; i <= WIDTH; ++i) {
          e = (int) scanner_read();
          e += (int) calib[WIDTH - i];
          if (e > 255)
            e = 255;

          buf[WIDTH - i] = e;
        }
        fwrite(buf, 1, WIDTH, f);
      } else {
        for (i = 1; i <= OBWIDTH; ++i) {
          buf[OBWIDTH - i] = flip_byte[scanner_read()];
        }
        fwrite(buf, 1, OBWIDTH, f);
      }

      h++;

      if (quitme) {
        abort_scan();
        break;
      }


      scanner_write_oob(0x1);
      k = scanner_read();
      SHORTSLEEP;
      scanner_write_oob(0x4);
      l = scanner_read();

      if (l < 0x90) {
        MOTORSLEEP;
        MOTORSLEEP;
        MOTORSLEEP;
        MOTORSLEEP;
      } else if (l < 0x98) {
        MOTORSLEEP;
      }

      if (l == 0x80)
        break;
    }

    fseek(f, off, SEEK_SET);
    fprintf(f, "%8d %8d\n", grey ? WIDTH : (OBWIDTH * 8), h);
    fseek(f, 0, SEEK_END);
    fclose(f);

    if (quitme)
      return 0;

    printf("Step 3: %x %x\n", k, l);


    if (grey)
      stop_eightbit();
    else
      stop_onebit();
  }
  while ((get_state() & 1) == 0);
}

void usage(void)
{
  printf("usage:\n");
  printf("paperease [-8] [-p port] [filename]\n");
  printf("\n");
  printf(" -8 	      put the scanner into 8 bit greyscale mode\n");
  printf("              default is 1 bit\n");
  printf(" -p port    use the parallel port at address port, port\n");
  printf("              may be decimal or hex prefixed by 0x\n");
  printf("              the default is 0x378\n");
  printf(" filename   use the filename as the base for the scanned\n");
  printf("              images insert a printf style format string\n");
  printf("              for multiple pages\n");
  exit(1);
}

int main(int argc, char *argv[])
{
  int i, c;
  int grey = 0;
  extern int optind;
  extern char *optarg;
  char *base;
  char buf[1024], gbuf[1024], pbuf[1024];

  printf("paperease %s\n", rcsid);
  printf("(c) 2002 James McKenzie\n");
  printf("NO WARRANTY Express, Implied or Otherwise see the file\n");
  printf("LICENSE in the distribuition\n");
  printf("CAUTION -- do not interrupt this program with anything\n");
  printf("other than SIGINT as it may burn the motor on your scanner\n");
  printf("\n");

  for (i = 0; i < 0x100; ++i) {
    flip_byte[i] = ((i & 0x1) ? 0 : 0x80) | ((i & 0x2) ? 0 : 0x40) |
        ((i & 0x4) ? 0 : 0x20) | ((i & 0x8) ? 0 : 0x10) |
        ((i & 0x10) ? 0 : 0x8) | ((i & 0x20) ? 0 : 0x4) |
        ((i & 0x40) ? 0 : 0x2) | ((i & 0x80) ? 0 : 0x1);
  }
  while ((c = getopt(argc, argv, "8p:")) != -1) {
    switch (c) {
    case '8':
      grey++;
      break;
    case 'p':
      if (strncmp(optarg, "0x", 2)) {
        port = atoi(optarg);
      } else {
        port = strtol(optarg + 2, (char **) NULL, 16);
      }
      break;
    case '?':
      usage();
      break;
    }
  }

  if (optind < argc) {
    base = argv[optind];
  } else {
    int scan = 0;
    do {
      scan++;
      sprintf(buf, "scan%04d.page001.pbm", scan);
      sprintf(gbuf, "scan%04d.page001.pgm", scan);
      sprintf(pbuf, "scan%04d.page001.png", scan);
    }
    while ((access(buf, F_OK) == 0) || (access(gbuf, F_OK) == 0)
           || (access(pbuf, F_OK) == 0));

    if (grey)
      sprintf(base = buf, "scan%04d.page%%03d.pgm", scan);
    else
      sprintf(base = buf, "scan%04d.page%%03d.pbm", scan);
  }


  {
    struct sigaction act = { 0 };

    act.sa_flags = SA_RESTART;
    act.sa_handler = sigint;

    sigaction(SIGINT, &act, NULL);
  }

  printf("Scanning into %s\n", base);

  init_scanner();

  while (get_state() & 1) {
    if (quitme)
      return 1;
    sleep(1);
  }

  if (get_state() == 0x82) {
    printf("Paper jam\n");

    return 1;
  }

  printf("Paper now in scanner %x\n", get_state());

  scan_pages(base, grey);

  for (i = 0; i < 10; ++i) {
    SCHEDULINGSLEEP;
    get_state();
  }
  return 0;

}
