.\" 
.\"/*************************************************
.\"*     paperease - an IBM style RIPL server            *
.\"*************************************************/
.\"
.\"Copyright (c) 2002, James McKenzie.
.\"                     All rights reserved
.\"
.\"By using this file, you agree to the terms and conditions set
.\"forth in the LICENSE file which can be found in the paperease
.\"distribution.
.\"
.\"Paperease may well be a trademark of Primax
.\"
.\"
.\"
.\" $Id: paperease.man,v 1.2 2002/05/19 16:15:46 root Exp root $;
.\"
.\" $Log: paperease.man,v $
.\" Revision 1.2  2002/05/19 16:15:46  root
.\" *** empty log message ***
.\"
.\" Revision 1.1  2002/05/19 15:57:26  root
.\" Initial revision
.\"
.\"
.\";
.Dd May 19, 2002
.Dt PAPEREASE 1
.Os Linux
.Sh NAME
.Nm paperease
.Nd a driver for the Primax Paperease scanner
.Sh SYNOPSIS
.Nm paperease 
[\fI-8\fR] [\fI-p\ port\fR] [\fIfilename\fR] 
.Sh WARRANTY
.Nm paperease 
DOES NOT come with ANY WARRANTY, NOT even an IMPLIED WARRANTY.
.Sh OPTIONS
.Bl -tag -width Op
.It \fB\-8\fR
this flag causes \fBpaperease\fR to scan 8 bit greyscale images rather than black and white 1 bit images, the default file name will be scanNNNN.pageNNN.pgm rather than scanNNNN.pageNNN.pbm
.It \fB\-p\fR\ \fIport\fR
causes \fBpaperease\fR to use the parallel port at the address \fIport\fR. \fIport\fR may be in decimal or if prefixed by \fI0x\fR in hexadecimal.
.It \fBfilename\fR
set the filename to which the scanned images will be written, a printf style string will be expanded to the page number. By default paperease looks for the first filename of the form \fIscan%04d.page001.{pbm,pgm,png}\fR which doesn't exist and uses that as a base.
.It 
any other option will cause \fBpaperease\fR to print a brief help message.
.El
.Sh DESCRIPTION
\fBpaperease\fR
allows you to use the Primax Paperease scanner under Linux and other x86 
operating systems. 
.Sh BUGS
.Bl -tag -width 0 -compact
.It
BE VERY CAREFUL WHEN QUITTING \fBpaperease\fR. It is possible to leave the scanner in a state with its motor coils turned on, you should not kill paperease except by pressing CTRL-C which will cause paperease to attempt to turn off the scanner. However if your scanner melts or sets fire to your cat it's entirely your problem this software comes with NO WARRANTY. That said running paperease with no arguments and then killing it with SIGINT or CTRL-C \fBshould\fR shutdown the scanner.

.It
Solenopsis invicta Burens

.It
paperease doesn't do calibration very well.

.Sh NOTES
.Pp
Paperease may well be a trademark of Primax.
.Sh SEE ALSO
.Pp
.Bl -tag -width 0 -compact
.It Pa printf(3),
.It Pa http://gimel.esc.cam.ac.uk/james/paperease;
.El
.Sh AUTHORS AND COPYRIGHT
.Pp
(c) 2002 James McKenzie, All rights reserved.
