/*
 *    paperease: a driver for the Primax Paperease scanner
 *    (c) 2002 James McKenzie <james@fishsoup.dhs.org>. 
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License , or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program. If not, write to the Free Software
 *    Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *    This program was produced by running the windows drivers
 *    for the program and recording all accesses to the parallel
 *    port circuitry passing the results through awk, sed and uniq.
 *
 *    Take care not to quit this program except by using 
 *    SIGINT - doing do may burn out the motor on your 
 *    scanner.
 *
 */
/* calib.c */
unsigned char calib[2548];
/* io.c */
int port;
void doublec(void);
int scanner_read(void);
void scanner_write(int v);
void scanner_write_oob(int v);
void scanner_write_oob_reset(int v);
void scanner_write_upcounting_256(void);
int scanner_read_upcounting_256(void);
int scanner_read_noisy(char *file, int line, char *func);
int init_port(void);
/* main.c */
unsigned char flip_byte[0x100];
int quitme;
void sigint(int dummy);
int abort_scan(void);
int scan_pages(char *base, int grey);
void usage(void);
int main(int argc, char *argv[]);
/* util.c */
void sleepdown(void);
void wakeup(void);
int init_scanner(void);
int get_state(void);
int start_onebit(void);
int stop_onebit(void);
int start_eightbit(void);
int stop_eightbit(void);
