/*
 *    paperease: a driver for the Primax Paperease scanner
 *    (c) 2002 James McKenzie <james@fishsoup.dhs.org>. 
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License , or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program. If not, write to the Free Software
 *    Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *    This program was produced by running the windows drivers
 *    for the program and recording all accesses to the parallel
 *    port circuitry passing the results through awk, sed and uniq.
 *
 *    Take care not to quit this program except by using 
 *    SIGINT - doing do may burn out the motor on your 
 *    scanner.
 *
 */
/*
 * util.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] = "$Id: util.c,v 1.18 2002/05/19 15:56:36 root Exp $";

/*
 * $Log: util.c,v $
 * Revision 1.18  2002/05/19 15:56:36  root
 * *** empty log message ***
 *
 * Revision 1.17  2002/05/19 15:21:05  root
 * *** empty log message ***
 *
 * Revision 1.16  2002/05/19 15:20:59  root
 * *** empty log message ***
 *
 * Revision 1.15  2002/05/19 10:50:06  root
 * *** empty log message ***
 *
 * Revision 1.14  2002/05/18 16:52:51  root
 * *** empty log message ***
 *
 * Revision 1.13  2002/05/18 16:52:44  root
 * *** empty log message ***
 *
 * Revision 1.12  2002/05/18 16:52:43  root
 * *** empty log message ***
 *
 * Revision 1.11  2002/05/18 16:52:39  root
 * *** empty log message ***
 *
 * Revision 1.10  2002/05/18 16:33:47  root
 * *** empty log message ***
 *
 * Revision 1.9  2002/05/18 16:33:26  root
 * *** empty log message ***
 *
 * Revision 1.8  2002/05/18 15:30:16  root
 * *** empty log message ***
 *
 * Revision 1.7  2002/05/18 15:30:10  root
 * *** empty log message ***
 *
 * Revision 1.6  2002/05/18 14:40:49  root
 * *** empty log message ***
 *
 * Revision 1.5  2002/05/18 11:25:40  root
 * *** empty log message ***
 *
 * Revision 1.4  2002/05/18 10:37:47  root
 * *** empty log message ***
 *
 * Revision 1.3  2002/05/18 10:34:19  root
 * *** empty log message ***
 *
 * Revision 1.2  2002/05/18 10:34:09  root
 * *** empty log message ***
 *
 * Revision 1.1  2002/05/18 10:33:47  root
 * Initial revision
 *
 */


#include "project.h"

void sleepdown(void)
{
  OUT(0x04, port + 2);
  OUT(0x00, port);
  IN(port);
  OUT(0x01, port);
  doublec();
  IN(port);
  OUT(0x81, port);
  doublec();
  IN(port);
  OUT(0x81, port);
  doublec();
  IN(port);
  OUT(0x80, port);
  doublec();
  IN(port);
  OUT(0x80, port);
  doublec();
  doublec();
  doublec();
  doublec();
  IN(port + 2);
  OUT(0x0c, port + 2);
}

void wakeup(void)
{
  IN(port + 2);
  OUT(0x04, port + 2);
  OUT(0x02, port);
  IN(port);
  OUT(0x03, port);
  doublec();
  IN(port);
  OUT(0x83, port);
  doublec();
  IN(port);
  OUT(0x83, port);
  doublec();
  IN(port);
  OUT(0x82, port);
  doublec();
  IN(port);
  OUT(0x82, port);
  doublec();
  doublec();
  doublec();
  doublec();
  OUT(0xff, port);
}

int init_scanner(void)
{
  int i;

  init_port();

  IN(port + 2);
  OUT(0x08, port + 2);
  OUT(0x0c, port + 2);
  IN(port + 1);
  wakeup();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_read_upcounting_256();
  LONGSLEEP;
  wakeup();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob(0x2);
  scanner_write_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob(0x2);
  scanner_read_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_read_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob(0x2);
  scanner_write_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob(0x2);
  scanner_read_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_read_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob(0x2);
  scanner_write_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob(0x2);
  scanner_read_upcounting_256();
  LONGSLEEP;
  wakeup();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x0c);
  SHORTSLEEP;
  scanner_write_oob_reset(0x5);
  for (i = 0; i < 2592; ++i) {
    scanner_write(0xff);
  }
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write(0x00);
  SHORTSLEEP;
  sleepdown();


  LONGSLEEP;
  wakeup();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_read_upcounting_256();
  LONGSLEEP;
  wakeup();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x0c);
  SHORTSLEEP;
  scanner_write_oob_reset(0x5);
  for (i = 0; i < 2592; ++i) {
    scanner_write(0xff);
  }
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write(0x00);
  SHORTSLEEP;
  sleepdown();
}

/* ret&1==0 Top switch [paper in feeder] */
/* ret&2==0 Bottom switch [paper in scanner] */

int get_state(void)
{
  int r;
  LONGSLEEP;
  wakeup();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  scanner_write(0x0f);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write_upcounting_256();
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_read_upcounting_256();
  SHORTSLEEP;
  wakeup();
  LONGSLEEP;
  scanner_write_oob_reset(0x0);
  r = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  scanner_write(0x0f);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write(0x00);
  SHORTSLEEP;
  sleepdown();
  return r;
}


int start_onebit(void)
{
  int a, b, c, d, e, f, g, h;

  LONGSLEEP;
  wakeup();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  a = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0xb);
  b = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0x8);
  scanner_write(0x19);
  SHORTSLEEP;
  scanner_write_oob_reset(0x9);
  scanner_write(0x00);
  SHORTSLEEP;
  scanner_write_oob_reset(0xa);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob_reset(0xb);
  scanner_write(0x0a);
  SHORTSLEEP;
  scanner_write_oob_reset(0x1);
  scanner_write(0x24);
  SHORTSLEEP;
  scanner_write_oob_reset(0x1);
  scanner_write(0x24);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  c = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0xb);
  d = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0x6);
  scanner_write(0x08);
  e = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  f = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0x8);
  scanner_write(0x19);
  SHORTSLEEP;
  scanner_write_oob_reset(0x9);
  scanner_write(0x00);
  SHORTSLEEP;
  scanner_write_oob_reset(0xa);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob_reset(0xb);
  scanner_write(0x0a);
  SHORTSLEEP;
  scanner_write_oob_reset(0x1);
  scanner_write(0x24);
  SHORTSLEEP;
  scanner_write_oob_reset(0x1);
  scanner_write(0x24);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x2f);
  scanner_write(0x3f);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  g = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0xb);
  h = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0x4);
  scanner_write(0x08);
  printf("start_onebit: %02x %02x %02x %02x %02x %02x %02x %02x\n", a, b,
         c, d, e, f, g, h);
}

int stop_onebit()
{
  int a, b, c, d, e;
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  a = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0xb);
  b = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  c = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  d = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0xb);
  e = scanner_read();
  SHORTSLEEP;
  scanner_write_oob_reset(0x4);
  scanner_write(0x00);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  scanner_write(0x0f);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write(0x00);
  SHORTSLEEP;
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  scanner_write(0x0f);
  SHORTSLEEP;
  scanner_write_oob_reset(0x2);
  scanner_write(0x00);
  SHORTSLEEP;
  sleepdown();
  printf("stop_onebit: %02x %02x %02x %02x %02x\n", a, b, c, d, e);
}

int start_eightbit()
{
  int a, b, c, d, e, f, g, h;

  wakeup();
  scanner_write_oob_reset(0x0);
  a = scanner_read() /*==0x02*/ ;
  scanner_write_oob_reset(0xb);
  b = scanner_read() /*==0xea*/ ;
  scanner_write_oob_reset(0x8);
  scanner_write(0x19);
  scanner_write_oob_reset(0x9);
  scanner_write(0x00);
  scanner_write_oob_reset(0xa);
  scanner_write(0x0d);
  scanner_write_oob_reset(0xb);
  scanner_write(0x0a);
  scanner_write_oob_reset(0x1);
  scanner_write(0x24);
  scanner_write_oob_reset(0x1);
  scanner_write(0xe4);
  scanner_write_oob_reset(0x0);
  c = scanner_read() /*==0x02*/ ;
  scanner_write_oob_reset(0xb);
  d = scanner_read() /*==0xea*/ ;
  scanner_write_oob_reset(0x6);
  scanner_write(0x00);
  e = scanner_read() /*==0x00*/ ;
  scanner_write_oob_reset(0x0);
  f = scanner_read();
  scanner_write_oob_reset(0x8);
  scanner_write(0x19);
  scanner_write_oob_reset(0x9);
  scanner_write(0x00);
  scanner_write_oob_reset(0xa);
  scanner_write(0x0d);
  scanner_write_oob_reset(0xb);
  scanner_write(0x0a);
  scanner_write_oob_reset(0x1);
  scanner_write(0xe4);
  scanner_write_oob_reset(0x1);
  scanner_write(0xe4);
  scanner_write_oob_reset(0x0);
  scanner_write(0x00);
  scanner_write(0x01);
  scanner_write_oob_reset(0x0);
  scanner_write(0x2f);
  scanner_write(0x3f);
  scanner_write_oob_reset(0x0);
  g = scanner_read() /*==0x32*/ ;
  scanner_write_oob_reset(0xb);
  h = scanner_read() /*==0xea*/ ;
  scanner_write_oob_reset(0x4);
  scanner_write(0x09);

  printf("start_eightbit: %02x %02x %02x %02x %02x %02x %02x %02x\n", a, b,
         c, d, e, f, g, h);
}

int stop_eightbit()
{
  int a, b, c, d, e;
  scanner_write_oob_reset(0x0);
  a = scanner_read() /*==0x23*/ ;
  scanner_write_oob_reset(0xb);
  b = scanner_read() /*==0xea*/ ;
  scanner_write_oob_reset(0x0);
  c = scanner_read();
  scanner_write_oob_reset(0x0);
  d = scanner_read() /*==0x23*/ ;
  scanner_write_oob_reset(0xb);
  e = scanner_read() /*==0xea*/ ;
  scanner_write_oob_reset(0x4);
  scanner_write(0x01);
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  scanner_write(0x0f);
  scanner_write_oob_reset(0x2);
  scanner_write(0x00);
  scanner_write_oob_reset(0x0);
  scanner_write(0x0e);
  scanner_write(0x0f);
  scanner_write_oob_reset(0x2);
  scanner_write(0x00);
  sleepdown();
  printf("stop_eightbit: %02x %02x %02x %02x %02x\n", a, b, c, d, e);

}
