/*
 * astro.h:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

/*
 * $Id: astro.h,v 1.1 2002/08/21 21:22:44 root Exp $
 */

/*
 * $Log: astro.h,v $
 * Revision 1.1  2002/08/21 21:22:44  root
 * #
 *
 */

#ifndef __ASTRO_H__
#define __ASTRO_H__

#include <time.h>
#include <sys/types.h>
#include <math.h>

#define FALSE	0
#define TRUE	1

#define PI M_PI
#define V	(void)

/*  Frequently used astronomical constants */

#define J2000		    2451545.0    /* Julian day of J2000 epoch */
#define JulianCentury	    36525.0 /* Days in Julian century */
#define AstronomicalUnit    149597870.0 /* Astronomical unit in kilometres */
#define SunSMAX  (AstronomicalUnit * 1.000001018) /* Semi-major axis of Earth's orbit */
#define EarthRad            6378.14 /* Earth's equatorial radius, km (IAU 1976) */
#define LunatBase           2423436.0 /* Base date for E. W. Brown's numbered
                                         series of lunations (1923 January 16) */
#define SynMonth	    29.53058868 /* Synodic month (mean time from new Moon to new Moon) */

#define max(x, y) (((x) > (y)) ? (x) : (y)) /* Maximum */
#define min(x, y) (((x) < (y)) ? (x) : (y)) /* Maximum */
#define sgn(x) (((x) < 0) ? -1 : ((x) > 0 ? 1 : 0)) /* Extract sign */
//#define abs(x) ((x) < 0 ? (-(x)) : (x)) /* Absolute val */
#define fixangle(a) ((a) - 360.0 * (floor((a) / 360.0))) /* Fix angle */
#define fixangr(a)  ((a) - (PI*2) * (floor((a) / (PI*2)))) /* Fix angle in radians */
#define dtr(x) ((x) * (PI / 180.0)) /* Degree->Radian */
#define rtd(x) ((x) / (PI / 180.0)) /* Radian->Degree */

/* From astro.c  */

extern double ucttoj (long year, int mon, int mday,
                      int hour, int min, int sec);
extern double jtime (struct tm *t);
extern void jyear (double td, long *yy, int *mm, int *dd);
extern double gmst (double jd);
extern void sunpos (double jd, int apparent,
                    double *ra, double *dec, double *rv, double *slong);
extern double phase (double pdate, double *pphase, double *mage, double *dist,
                     double *angdia, double *sudist, double *suangdia);
extern void highmoon (double jd, double *l, double *b, double *r);
extern void ecliptoeq (double jd, double Lambda, double Beta, double *Ra,
                       double *Dec);

#endif /* __ASTRO_H__ */
