/*
 * ppmice.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] =
  "$Id: etopo5.c,v 1.1 2002/08/26 09:41:06 root Exp root $";

/*
 * $Log: etopo5.c,v $
 * Revision 1.1  2002/08/26 09:41:06  root
 * #
 *
 * Revision 1.9  2002/08/24 13:45:45  root
 * #
 *
 * Revision 1.8  2002/08/24 13:38:11  root
 * #
 *
 * Revision 1.7  2002/08/23 18:51:25  root
 * #
 *
 * Revision 1.6  2002/08/23 17:03:58  root
 * #
 *
 * Revision 1.5  2002/08/23 08:35:08  root
 * #
 *
 * Revision 1.4  2002/08/23 08:35:04  root
 * #
 *
 * Revision 1.3  2002/08/21 21:22:44  root
 * #
 *
 * Revision 1.2  2002/08/21 16:04:15  root
 * #
 *
 * Revision 1.1  2002/08/21 16:04:07  root
 * #
 *
 * Revision 1.1  2002/08/21 12:07:29  root
 * #
 *
 * Revision 1.2  2002/08/21 09:40:55  root
 * #
 *
 */

/*  ppmpc.c

    Project Earth image in Mollweide projection to rectangular
    Mercator bitmap.

    Based on the projection code from the GCTPc package, developed
    by the EROS Data Center.  GCTPc is available from the following
    FTP sites:

	ftp://edcftp.cr.usgs.gov/pub/software/gctpc/gctpc.tar.Z
	ftp://charon.er.usgs.gov/pub/S.gctpc.tar.Z

*/

#include <math.h>

#define EPS	0.05

#include "size.h"
#include <math.h>
#include <stdio.h>

#define NLON 4320
#define NLAT 2160
#define ISTEP 12.0
#define STEP (1.0/ISTEP)

int
pc (double lat, double lon, int *x, int *y)
{

  while (lon < 0.0)
    lon += 360.0;
  while (lon > 360.0)
    lon -= 360.0;

  *x = (int) ((lon * ISTEP) + .5);
  *y = (int) (((90.0 - lat) * ISTEP) + .5);

  if ((*x) < 0)
    (*x) += NLON;
  if ((*x) >= NLON)
    (*x) -= NLON;

  if ((*y) < 0)
    (*y) = 0;
  if ((*y) >= NLAT)
    (*y) = NLAT - 1;

}

int
main (argc, argv)
     int argc;
     char *argv[];
{
  FILE *f;

  char buf[1024];


  int x, y, lx, ux, ly, uy;
  int w, h;
  int i;
  int n;

  int **etopo5, *sptr;
  float **ft;
  float **blat, **blon;

  double scl;

  etopo5 = (int **) malloc (sizeof (int *) * NLAT);
  *etopo5 = (int *) malloc (sizeof (int) * NLAT * NLON);

  n = 0;

  //printf("P5\n%d %d\n255\n",NLON,NLAT);

  for (y = 0; y < NLAT; ++y)
    {
      fprintf (stderr, "Reading row %d/%d    \r", y, NLAT);
      sptr = etopo5[y] = etopo5[0] + (y * NLON);
      for (x = 0; x < NLON; x += 20)
        {
          char fbuf[7], *fptr = buf;

          fgets (buf, sizeof (buf) - 1, stdin);
          fbuf[6] = 0;

          for (i = 0; i < 20; i++)
            {
              bcopy (fptr, fbuf, 6);

              *sptr = atoi (fbuf);



              fptr += 6;
              sptr++;
              n++;
            }

        }
    }

  fprintf (stderr, "\n");

  for (y = 0; y < NLAT; ++y)
    {
      sptr = etopo5[y];
      for (x = 0; x < NLON; x++)
        {
          if ((*sptr) <= 0)
            *sptr = 0;
          sptr++;
        }
    }

  ft = (float **) malloc (sizeof (float *) * OHEIGHT);
  *ft = (float *) malloc (sizeof (float) * OHEIGHT * OWIDTH);

  printf ("P5\n%d %d\n255\n", OWIDTH, OHEIGHT);
  for (y = 0; y < OHEIGHT; ++y)
    {
      double lat =
        90.0 * ((double) ((OHEIGHT / 2) - y)) / ((double) (OHEIGHT / 2));

      ft[y] = ft[0] + (y * OWIDTH);

      for (x = 0; x < OWIDTH; ++x)
        {
          int ix, iy;
          double lon =
            180.0 * ((double) (x - (OWIDTH / 2))) / ((double) (OWIDTH / 2));

          pc (lat, lon, &ix, &iy);

          ft[y][x] = (float) etopo5[iy][ix];
          putchar (((int) etopo5[iy][ix]) / 12);

        }
    }




  free (*etopo5);
  free (etopo5);

  blon = (float **) malloc (sizeof (float *) * OHEIGHT);
  blat = (float **) malloc (sizeof (float *) * OHEIGHT);

  *blon = (float *) malloc (sizeof (float) * OHEIGHT * OWIDTH);
  *blat = (float *) malloc (sizeof (float) * OHEIGHT * OWIDTH);

#define RADIUS 6500000.0        //Radius of earth
#define EXAG 4.0                //Vertical exageration

  scl = (M_PI * RADIUS) / (double) OHEIGHT; //distance between two points of latitude;
  scl = EXAG / scl;

  fprintf (stderr, "\n");

  for (y = 0; y < OHEIGHT; ++y)
    {
      double lat =
        (M_PI / 2) * ((double) ((OHEIGHT / 2) - y)) /
        ((double) (OHEIGHT / 2));
      float xys = scl / (EPS + cos (lat));


      fprintf(stderr,"calculating bumps %d/%d    \r",y,OHEIGHT);

      uy = y - 1;
      ly = y + 1;

      if (uy < 0)
        uy = 0;
      if (ly >= OHEIGHT)
        ly = OHEIGHT - 1;

      blon[y] = blon[0] + (y * OWIDTH);
      blat[y] = blat[0] + (y * OWIDTH);

      lx = OWIDTH - 1;
      ux = 1;

      for (x = 0; x < OWIDTH; ++x)
        {
          blon[y][x] = atan ((ft[y][ux] - ft[y][lx]) * xys);
          blat[y][x] = atan ((ft[uy][x] - ft[ly][x]) * scl);

          ux++;
          lx++;

          if (ux >= OWIDTH)
            ux -= OWIDTH;
          if (lx >= OWIDTH)
            lx -= OWIDTH;

        }
    }


  free (*ft);
  free (ft);
  fprintf (stderr, "\n");

  fprintf (stderr, "Writing data\n");

  f = fopen ("NOBACKUP/blon.dat", "w");
  fwrite (*blon, sizeof (float) * OWIDTH, OHEIGHT, f);
  fclose (f);
  free (*blon);
  free (blon);

  f = fopen ("NOBACKUP/blat.dat", "w");
  fwrite (*blat, sizeof (float) * OWIDTH, OHEIGHT, f);
  fclose (f);
  free (*blat);
  free (blat);

  exit (0);
}
