(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3491,        132]*)
(*NotebookOutlinePosition[      4129,        155]*)
(*  CellTagsIndexPosition[      4085,        151]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(x[lat_, lon_] := Cos[lat] Cos[lon]\)], "Input"],

Cell[BoxData[
    \(y[lat_, lon_] := Cos[lat] Sin[lon]\)], "Input"],

Cell[BoxData[
    \(z[lat_, lon_] := Sin[lat]\)], "Input"],

Cell[BoxData[
    \(lat[x_, y_, z_] := atan2[z, \@\(x\^2 + y\^2\)]\)], "Input"],

Cell[BoxData[
    \(lon[x_, y_, z_] := atan2[y, x]\)], "Input"],

Cell[BoxData[
    \(rx[lat_, lon_, phi_] := x[lat, lon] Cos[phi] - z[lat, lon] Sin[phi]\)], 
  "Input"],

Cell[BoxData[
    \(ry[lat_, lon_, phi_] := y[lat, lon]\)], "Input"],

Cell[BoxData[
    \(rz[lat_, lon_, phi_] := Cos[phi] z[lat, lon] + Sin[phi] x[lat, lon]\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CF = {rx\^2 -> rx2, ry\^2 -> ry2, Sin[phi] -> sphi, Cos[phi] -> cphi}
        \)], "Input"],

Cell[BoxData[
    \({rx\^2 \[Rule] rx2, ry\^2 \[Rule] ry2, Sin[phi] \[Rule] sphi, 
      Cos[phi] \[Rule] cphi}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input"],

Cell["cphi*Cos(lat)*Cos(lon) - sphi*Sin(lat)", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CForm[
      lat[\t\trx[lat, lon, phi], ry[lat, lon, phi], \trz[lat, lon, phi]] /. 
        CF]\)], "Input"],

Cell["\<\
atan2(sphi*Cos(lat)*Cos(lon) + 
    cphi*Sin(lat),
   Sqrt(Power(cphi*Cos(lat)*Cos(lon) - 
       sphi*Sin(lat),2) + 
     Power(Cos(lat),2)*Power(Sin(lon),2)
     ))\
\>", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CForm[
      lon[\t\trx[lat, lon, phi], ry[lat, lon, phi], \trz[lat, lon, phi]] /. 
        CF]\)], "Input"],

Cell["\<\
atan2(Cos(lat)*Sin(lon),
   cphi*Cos(lat)*Cos(lon) - 
    sphi*Sin(lat))\
\>", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CForm[lon[rx, ry, rz]]\)], "Input"],

Cell["atan2(ry,rx)", "Output"]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1312}, {0, 1024}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 184}, {Automatic, 158}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 67, 1, 32, "Input"],
Cell[1779, 52, 67, 1, 32, "Input"],
Cell[1849, 55, 58, 1, 32, "Input"],
Cell[1910, 58, 79, 1, 48, "Input"],
Cell[1992, 61, 63, 1, 32, "Input"],
Cell[2058, 64, 103, 2, 55, "Input"],
Cell[2164, 68, 68, 1, 32, "Input"],
Cell[2235, 71, 103, 2, 55, "Input"],

Cell[CellGroupData[{
Cell[2363, 77, 111, 2, 68, "Input"],
Cell[2477, 81, 125, 2, 67, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2639, 88, 26, 0, 32, "Input"],
Cell[2668, 90, 56, 0, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2761, 95, 128, 3, 78, "Input"],
Cell[2892, 100, 192, 7, 144, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3121, 112, 128, 3, 78, "Input"],
Cell[3252, 117, 98, 4, 84, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3387, 126, 55, 1, 32, "Input"],
Cell[3445, 129, 30, 0, 44, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

