(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     63275,       1746]*)
(*NotebookOutlinePosition[     63912,       1769]*)
(*  CellTagsIndexPosition[     63868,       1765]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(P := 1.707\)], "Input"],

Cell[BoxData[
    \(R := 1.0\)], "Input"],

Cell[BoxData[
    \(rho[lat_] := R\ \((P - 1)\)\ Cos[lat]\/\((P - Sin[lat])\)\)], "Input"],

Cell[BoxData[
    \(x[lat_, lon_] := rho[lat]\ Sin[lon]\)], "Input"],

Cell[BoxData[
    \(y[lat_, lon_] := \(-rho[lat]\)\ Cos[lon]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rho[1]\)], "Input"],

Cell[BoxData[
    \(0.441341334078779112`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[{rho[lat], Sin[lat], 1/P}, {lat, \(-\[Pi]\), \[Pi]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.151576 0.309018 0.294303 [
[.04527 .29652 -6 -9 ]
[.04527 .29652 6 0 ]
[.19685 .29652 -6 -9 ]
[.19685 .29652 6 0 ]
[.34842 .29652 -6 -9 ]
[.34842 .29652 6 0 ]
[.65158 .29652 -3 -9 ]
[.65158 .29652 3 0 ]
[.80315 .29652 -3 -9 ]
[.80315 .29652 3 0 ]
[.95473 .29652 -3 -9 ]
[.95473 .29652 3 0 ]
[.4875 .01471 -12 -4.5 ]
[.4875 .01471 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04527 .30902 m
.04527 .31527 L
s
[(-3)] .04527 .29652 0 1 Mshowa
.19685 .30902 m
.19685 .31527 L
s
[(-2)] .19685 .29652 0 1 Mshowa
.34842 .30902 m
.34842 .31527 L
s
[(-1)] .34842 .29652 0 1 Mshowa
.65158 .30902 m
.65158 .31527 L
s
[(1)] .65158 .29652 0 1 Mshowa
.80315 .30902 m
.80315 .31527 L
s
[(2)] .80315 .29652 0 1 Mshowa
.95473 .30902 m
.95473 .31527 L
s
[(3)] .95473 .29652 0 1 Mshowa
.125 Mabswid
.07559 .30902 m
.07559 .31277 L
s
.1059 .30902 m
.1059 .31277 L
s
.13622 .30902 m
.13622 .31277 L
s
.16653 .30902 m
.16653 .31277 L
s
.22716 .30902 m
.22716 .31277 L
s
.25748 .30902 m
.25748 .31277 L
s
.28779 .30902 m
.28779 .31277 L
s
.31811 .30902 m
.31811 .31277 L
s
.37874 .30902 m
.37874 .31277 L
s
.40905 .30902 m
.40905 .31277 L
s
.43937 .30902 m
.43937 .31277 L
s
.46968 .30902 m
.46968 .31277 L
s
.53032 .30902 m
.53032 .31277 L
s
.56063 .30902 m
.56063 .31277 L
s
.59095 .30902 m
.59095 .31277 L
s
.62126 .30902 m
.62126 .31277 L
s
.68189 .30902 m
.68189 .31277 L
s
.71221 .30902 m
.71221 .31277 L
s
.74252 .30902 m
.74252 .31277 L
s
.77284 .30902 m
.77284 .31277 L
s
.83347 .30902 m
.83347 .31277 L
s
.86378 .30902 m
.86378 .31277 L
s
.8941 .30902 m
.8941 .31277 L
s
.92441 .30902 m
.92441 .31277 L
s
.01496 .30902 m
.01496 .31277 L
s
.98504 .30902 m
.98504 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01471 m
.50625 .01471 L
s
[(-1)] .4875 .01471 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .18712 m
.06244 .20624 L
.10458 .2281 L
.14415 .24874 L
.18221 .26841 L
.22272 .28912 L
.26171 .30892 L
.30316 .32996 L
.34309 .35038 L
.3815 .37025 L
.42237 .39157 L
.46172 .41197 L
.49955 .4307 L
.52059 .44019 L
.53984 .44786 L
.54934 .45114 L
.55972 .45423 L
.56945 .45657 L
.57422 .4575 L
.57861 .4582 L
.58357 .45882 L
.58617 .45906 L
.5875 .45916 L
.58893 .45925 L
.59014 .45931 L
.59124 .45936 L
.59234 .45939 L
.59339 .45941 L
.59461 .45942 L
.59573 .45942 L
.59697 .4594 L
.59828 .45936 L
.59957 .45931 L
.60076 .45924 L
.60343 .45904 L
.60578 .4588 L
.60825 .45847 L
.61351 .45753 L
.61926 .4561 L
.62454 .45439 L
.62953 .45241 L
.63887 .44767 L
.64892 .44097 L
.65982 .43171 L
.67969 .40923 L
.70074 .37788 L
.73862 .30799 L
.7597 .2678 L
.77896 .23444 L
.79911 .20544 L
Mistroke
.81779 .18501 L
.827 .17727 L
.83681 .17067 L
.84242 .16761 L
.84769 .16519 L
.85239 .16338 L
.85755 .16176 L
.86261 .16052 L
.86734 .15965 L
.86995 .15929 L
.87233 .15903 L
.87364 .15892 L
.87507 .15881 L
.87642 .15874 L
.87767 .15868 L
.87873 .15865 L
.87987 .15862 L
.88095 .15861 L
.88193 .15862 L
.88303 .15863 L
.88422 .15865 L
.88547 .1587 L
.88664 .15875 L
.88905 .1589 L
.89124 .15908 L
.89615 .15963 L
.90102 .16037 L
.90616 .16134 L
.91537 .16351 L
.93619 .17012 L
.97412 .18615 L
.97619 .18712 L
Mfstroke
.02381 .30902 m
.06244 .23481 L
.10458 .15951 L
.14415 .09914 L
.18221 .05447 L
.20178 .03757 L
.21267 .03011 L
.22272 .0245 L
.23293 .02007 L
.23832 .01827 L
.24402 .01676 L
.24641 .01625 L
.24897 .01579 L
.25119 .01545 L
.25361 .01516 L
.25507 .01501 L
.25643 .01491 L
.25773 .01483 L
.2584 .01479 L
.25912 .01476 L
.25983 .01474 L
.26048 .01473 L
.26176 .01472 L
.26293 .01472 L
.26416 .01475 L
.26538 .01479 L
.26607 .01483 L
.26671 .01486 L
.26912 .01505 L
.27131 .01528 L
.27364 .0156 L
.27847 .01647 L
.2838 .01778 L
.29326 .02099 L
.30213 .02502 L
.32232 .03778 L
.34082 .05371 L
.38045 .10022 L
.41855 .15838 L
.45911 .23059 L
.49816 .30545 L
.53966 .38514 L
.57964 .45663 L
.61811 .51582 L
.63759 .54096 L
.65902 .56418 L
.67938 .58152 L
.69843 .5933 L
.70884 .59785 L
.71396 .5996 L
Mistroke
.71872 .60092 L
.72301 .60186 L
.72758 .60261 L
.7302 .60292 L
.73148 .60304 L
.73266 .60313 L
.73371 .6032 L
.73487 .60325 L
.73603 .60329 L
.73725 .60332 L
.73856 .60332 L
.73977 .6033 L
.7404 .60329 L
.7411 .60326 L
.74251 .6032 L
.74375 .60312 L
.74508 .60301 L
.74748 .60276 L
.74985 .60244 L
.75235 .60202 L
.7568 .60108 L
.76198 .59967 L
.7668 .59806 L
.77773 .59332 L
.78828 .58734 L
.79823 .58046 L
.81683 .5645 L
.85534 .51958 L
.89632 .45703 L
.93577 .38657 L
.97371 .31383 L
.97619 .30902 L
Mfstroke
.02381 .48143 m
.06244 .48143 L
.10458 .48143 L
.14415 .48143 L
.18221 .48143 L
.22272 .48143 L
.26171 .48143 L
.30316 .48143 L
.34309 .48143 L
.3815 .48143 L
.42237 .48143 L
.46172 .48143 L
.49955 .48143 L
.53984 .48143 L
.57861 .48143 L
.61984 .48143 L
.65954 .48143 L
.69774 .48143 L
.73838 .48143 L
.77751 .48143 L
.81909 .48143 L
.85916 .48143 L
.89771 .48143 L
.93871 .48143 L
.97619 .48143 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oS`3oool0
0`000000oooo0?ooo`2>0?ooo`00S`3oool00`000000oooo0?ooo`2>0?ooo`00S`3oool00`000000
oooo0?ooo`2>0?ooo`00QP3oool4000000D0oooo00<000000?ooo`3oool0SP3oool004L0oooo2000
000i0?ooo`030000003oool0oooo00@0oooo0`00002>0?ooo`00A03oool4000000L0oooo1000000e
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0SP3oool00480oooo0P00000?0?oo
o`<00000:P3oool4000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2>0?oo
o`00?`3oool3000001@0oooo0P00000`0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0SP3oool003d0oooo0P00000I0?ooo`030000003oool0oooo02/0oooo0`0000060?ooo`030000
003oool0oooo08h0oooo000l0?ooo`030000003oool0oooo01X0oooo0P00000]0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0SP3oool003/0oooo00<000000?ooo`3oool07@3oool0
0`000000oooo0?ooo`0a0?ooo`030000003oool0oooo08h0oooo000j0?ooo`030000003oool0oooo
01l0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`2>0?ooo`00>03oool2000002<0
oooo0P00000`0?ooo`800000S`3oool003L0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`0]0?ooo`030000003oool0oooo08h0oooo000e0?ooo`800000:@3oool2000002d0oooo00<0
00000?ooo`3oool0SP3oool003@0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0Z
0?ooo`030000003oool0oooo08h0oooo000c0?ooo`030000003oool0oooo02d0oooo00<000000?oo
o`3oool0:@3oool00`000000oooo0?ooo`2>0?ooo`00<P3oool00`000000oooo0?ooo`0_0?ooo`03
0000003oool0oooo02P0oooo00<000000?ooo`3oool0SP3oool00340oooo00<000000?ooo`3oool0
<@3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo08h0oooo000a0?ooo`030000003o
ool0oooo0340oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`2>0?ooo`00<03oool0
0`000000oooo0?ooo`0c0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0SP3oool0
02l0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0U0?ooo`800000S`3oool002h0
oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo08h0
oooo000]0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`2>0?ooo`00;03oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo0280oooo00<0
00000?ooo`3oool0SP3oool002`0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0R
0?ooo`030000003oool0oooo08h0oooo000[0?ooo`030000003oool0oooo03d0oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`2>0?ooo`00:P3oool00`000000oooo0?ooo`0o0?ooo`03
0000003oool0oooo0200oooo00<000000?ooo`3oool0SP3oool002T0oooo00<000000?ooo`3oool0
@@3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo08h0oooo000X0?ooo`030000003o
ool0oooo04<0oooo00<000000?ooo`3oool07P3oool2000008l0oooo000X0?ooo`030000003oool0
oooo04<0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`2>0?ooo`009`3oool00`00
0000oooo0?ooo`150?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0SP3oool002H0
oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo08h0
oooo000V0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0703oool00`000000oooo
0?ooo`2>0?ooo`009@3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo01/0oooo00<0
00000?ooo`3oool0SP3oool002@0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0J
0?ooo`030000003oool0oooo08h0oooo000T0?ooo`030000003oool0oooo04/0oooo00<000000?oo
o`3oool06P3oool00`000000oooo0?ooo`2>0?ooo`008`3oool00`000000oooo0?ooo`1=0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool0SP3oool002<0oooo00<000000?ooo`3oool0
C@3oool00`000000oooo0?ooo`0I0?ooo`800000S`3oool00280oooo00<000000?ooo`3oool0C`3o
ool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo08h0oooo000Q0?ooo`030000003oool0
oooo0540oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`2>0?ooo`008@3oool00`00
0000oooo0?ooo`1A0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0SP3oool00200
oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo08h0
oooo000O0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`2>0?ooo`007`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool0SP3oool001h0oooo00<000000?ooo`3oool0E`3oool00`000000oooo0?ooo`02
000000@0oooo00<000000?ooo`3oool00P3oool3000000H0oooo00<000000?ooo`3oool0I@3oool:
000001l0oooo000M0?ooo`030000003oool0oooo05T0oooo0P0000020?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool00`3oool300000640oooo1000000:0?ooo`@000006`3oool001d0
oooo00<000000?ooo`3oool0F@3oool200000080oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool0403oool4000001L0
oooo000L0?ooo`030000003oool0oooo05D0oooo100000020?ooo`040000003oool0oooo000000P0
oooo0`0000060?ooo`030000003oool0oooo05h0oooo0P00000G0?ooo`@000004`3oool001`0oooo
00<000000?ooo`3oool0F`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00H0
oooo00<000000?ooo`3oool0G03oool2000001d0oooo0P00000A0?ooo`006`3oool00`000000oooo
0?ooo`1L0?ooo`80000000<0oooo0000003oool01`3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo05X0oooo0P00000Q0?ooo`8000003`3oool001/0oooo00<000000?ooo`3oool0G@3o
ool2000000T0oooo100000050?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool08`3o
ool2000000d0oooo000J0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`1I0?ooo`030000003oool0oooo02D0oooo0P00000;0?ooo`001`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`1H0?ooo`030000003oool0oooo02P0oooo0`0000080?ooo`00203oool2000000l0
oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`0?0?ooo`800000F03oool00`000000
oooo0?ooo`0d0?ooo`002P3oool2000000d0oooo00<000000?ooo`3oool0H@3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo05D0oooo0P00000g0?ooo`00303oool2000000X0oooo00<0
00000?ooo`3oool0H`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo05@0oooo00<0
00000?ooo`3oool0=`3oool000h0oooo0P0000070?ooo`030000003oool0oooo06@0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo03P0oooo000@0?oo
o`8000001@3oool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool0DP3oool00`000000oooo0?ooo`0i0?ooo`004P3oool01@000000oooo0?ooo`3oool00000
06P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo
03X0oooo000C0?ooo`80000000<0oooo0000003oool0J03oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo0540oooo00<000000?ooo`3oool0>P3oool001D0oooo0P00001Y0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`0k0?ooo`005@3o
ool010000000oooo00000000001X0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0
D03oool00`000000oooo0?ooo`0k0?ooo`00503oool00`000000oooo0?ooo`020?ooo`800000IP3o
ool00`000000oooo0?ooo`0;0?ooo`800000D03oool00`000000oooo0?ooo`0l0?ooo`00503oool0
0`000000oooo0?ooo`040?ooo`800000I@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo04l0oooo00<000000?ooo`3oool0?03oool001<0oooo00<000000?ooo`3oool01`3oool20000
06<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo
03d0oooo000C0?ooo`030000003oool0oooo00T0oooo0P00001R0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`0m0?ooo`004P3oool00`000000oooo
0?ooo`0<0?ooo`800000H@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo04d0oooo
00<000000?ooo`3oool0?P3oool00140oooo00<000000?ooo`3oool03`3oool2000005l0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo03l0oooo000A
0?ooo`030000003oool0oooo0140oooo0P00001N0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool0C03oool00`000000oooo0?ooo`0o0?ooo`00403oool00`000000oooo0?ooo`0D0?oo
o`800000G03oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo04/0oooo00<000000?oo
o`3oool0@03oool00100oooo00<000000?ooo`3oool05P3oool2000005/0oooo00<000000?ooo`3o
ool01P3oool2000004/0oooo00<000000?ooo`3oool0@@3oool000l0oooo00<000000?ooo`3oool0
6@3oool2000005T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`1:0?ooo`030000
003oool0oooo0440oooo000?0?ooo`030000003oool0oooo01/0oooo0P00001H0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`120?ooo`003P3oool0
0`000000oooo0?ooo`0N0?ooo`800000EP3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo04P0oooo00<000000?ooo`3oool0@`3oool000h0oooo00<000000?ooo`3oool0803oool20000
05D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
04<0oooo000=0?ooo`030000003oool0oooo02<0oooo0P00001C0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`140?ooo`003@3oool00`000000oooo
0?ooo`0U0?ooo`800000DP3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo04L0oooo
00<000000?ooo`3oool0A03oool000`0oooo00<000000?ooo`3oool0:03oool200000500oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo04D0oooo000<
0?ooo`030000003oool0oooo00800000:03oool5000002L0oooo1000000Q0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool09P3oool4000001`0oooo00<000000?ooo`3oool0203oool4
000002T0oooo0P00000>0?ooo`002`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0
oooo02H0oooo0`00000Z0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool00P3oool2
000002T0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo02T0oooo00@000000?ooo`3oool000003@3oool000/0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0W0?ooo`040000003oool00000000002P0oooo00<000000?ooo`3oool08@3o
ool01@000000oooo0?ooo`3oool0000002X0oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool02`3oool000P0oooo1000
00030?ooo`8000008`3oool4000000@0oooo00<000000?ooo`3oool00P00000N0?ooo`@00000103o
ool00`000000oooo0?ooo`0Q0?ooo`050000003oool0oooo0?ooo`000000:P3oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0:03oool2000000h0oooo
000:0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0:@3oool010000000oooo0?oo
o`3oool2000002@0oooo00<000000?ooo`3oool08P3oool010000000oooo0?ooo`00000Z0?ooo`03
0000003oool0oooo01T0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0Y0?ooo`03
0000003oool0oooo00/0oooo00090?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool0
0000:03oool010000000oooo0?ooo`0000050?ooo`800000803oool3000002@0oooo00@000000?oo
o`3oool00000:03oool3000001X0oooo00<000000?ooo`3oool02`3oool010000000oooo0?ooo`00
000X0?ooo`040000003oool0oooo000000d0oooo00090?ooo`030000003oool0oooo00<0oooo0P00
000Z0?ooo`800000203oool200000200oooo00<000000?ooo`3oool08`3oool00`000000oooo0000
000Z0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0303oool2000002X0oooo0P00
000>0?ooo`00203oool00`000000oooo0?ooo`0l0?ooo`800000A03oool00`000000oooo00000014
0?ooo`030000003oool0oooo04T0oooo00080?ooo`030000003oool0oooo03h0oooo0P0000130?oo
o`800000A03oool00`000000oooo0?ooo`190?ooo`00o`00000P00000040oooo00050?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool010000000oooo0000000000040?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0000000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000060?oo
o`003@3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo0180oooo0P00000D0?ooo`03
0000003oool0oooo02P0oooo0P00000Y0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0Y0?ooo`050000003oool0oooo0?ooo`0000002P3oool00500
oooo0P00000m0?ooo`800000@03oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo00P0
oooo001B0?ooo`800000>`3oool00`000000oooo0000000o0?ooo`030000003oool0oooo0400oooo
00<000000?ooo`3oool02@3oool005@0oooo0P00000i0?ooo`030000003oool0000003h0oooo00<0
00000?ooo`3oool0@@3oool00`000000oooo0?ooo`090?ooo`00EP3oool2000003L0oooo00@00000
0?ooo`3oool00000?@3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo00X0oooo001H
0?ooo`800000=@3oool010000000oooo0?ooo`00000l0?ooo`030000003oool0oooo0440oooo00<0
00000?ooo`3oool02P3oool005X0oooo0P00000c0?ooo`8000000P3oool00`000000oooo0?ooo`0i
0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool02`3oool005`0oooo0P00000a0?oo
o`050000003oool0oooo0?ooo`000000>P3oool00`000000oooo0?ooo`110?ooo`030000003oool0
oooo00/0oooo001N0?ooo`800000;`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0<0?ooo`00H03oool2000002d0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo0440
oooo00<000000?ooo`3oool0303oool00680oooo00<000000?ooo`3oool0:P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0@@3oool00`000000oooo
0?ooo`0=0?ooo`00H`3oool2000002X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0d0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool03@3oool006D0oooo0P00000X
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`11
0?ooo`030000003oool0oooo00h0oooo001W0?ooo`8000009P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo0380oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0>0?oo
o`00J@3oool2000002@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0`0?ooo`03
0000003oool0oooo0440oooo00<000000?ooo`3oool03`3oool006/0oooo0P00000R0?ooo`800000
1P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0
3`3oool006d0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo02h0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0@0?ooo`00KP3oool2
000001l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0
oooo0440oooo00<000000?ooo`3oool0403oool00700oooo0P00000M0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo
0140oooo001b0?ooo`8000006`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo02/0
oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0A0?ooo`00M03oool2000001T0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo0440oooo
00<000000?ooo`3oool04P3oool007H0oooo0P00000G0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0:03oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo01<0oooo001h
0?ooo`<00000503oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02L0oooo00<00000
0?ooo`3oool0@P3oool00`000000oooo0?ooo`0C0?ooo`00N`3oool200000180oooo0P00000;0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0D0?oo
o`00O@3oool200000100oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0U0?ooo`03
0000003oool0oooo0480oooo00<000000?ooo`3oool0503oool007l0oooo0P00000>0?ooo`030000
003oool0oooo00/0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`120?ooo`030000
003oool0oooo01D0oooo00210?ooo`800000303oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo0280oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`0E0?ooo`00P`3oool2
000000X0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0
oooo0480oooo00<000000?ooo`3oool05P3oool008D0oooo0P0000080?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo
01H0oooo00270?ooo`8000001P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01h0
oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0G0?ooo`00R@3oool2000000@0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo04<0oooo
00<000000?ooo`3oool05`3oool008/0oooo0P0000020?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo01P0oooo002=
0?ooo`@00000403oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo04<0oooo00<00000
0?ooo`3oool06@3oool008l0oooo0P00000A0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool0A03oool00`000000oooo0?ooo`0I0?ooo`00S`3oool00`000000oooo00000002000000h0
oooo00<000000?ooo`3oool05P3oool2000004H0oooo00<000000?ooo`3oool06P3oool008l0oooo
00<000000?ooo`3oool00P3oool2000000d0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`160?ooo`030000003oool0oooo01X0oooo002?0?ooo`030000003oool0oooo00@0oooo0P00
000<0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?oo
o`0K0?ooo`00S`3oool00`000000oooo0?ooo`060?ooo`8000002P3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool06`3oool008l0oooo00<000000?oo
o`3oool0203oool2000000T0oooo00<000000?ooo`3oool03P3oool2000004T0oooo00<000000?oo
o`3oool0703oool007/0oooo0P0000040?ooo`030000003oool0oooo0080oooo0`0000060?ooo`03
0000003oool0oooo00X0oooo1P0000030?ooo`030000003oool0oooo00`0oooo0P00001;0?ooo`03
0000003oool0oooo01`0oooo001j0?ooo`040000003oool0oooo000000/0oooo00<000000?ooo`3o
ool00`3oool300000100oooo0`0000000`3oool000000?ooo`070?ooo`D00000C03oool00`000000
oooo0?ooo`0M0?ooo`00NP3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool04`3oool:00000500oooo00<000000?ooo`3oool07P3oool007X0oooo
00@000000?ooo`3oool00000203oool3000000H0oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`1E0?ooo`030000003oool0oooo01h0oooo001j0?ooo`040000003oool0oooo000000P0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo05<0
oooo00<000000?ooo`3oool07`3oool007X0oooo00@000000?ooo`3oool00000203oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0D@3oool00`000000
oooo0?ooo`0P0?ooo`00N`3oool2000000T0oooo100000050?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`0P0?ooo`00S`3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool08@3oool000L0ooooo`00000B
000000P0oooo002?0?ooo`8000006P3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo
0280oooo002?0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0B`3oool00`000000
oooo0?ooo`0S0?ooo`00S`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo04X0oooo
00<000000?ooo`3oool0903oool008l0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?oo
o`190?ooo`030000003oool0oooo02@0oooo002?0?ooo`030000003oool0oooo01`0oooo00<00000
0?ooo`3oool0A`3oool00`000000oooo0?ooo`0U0?ooo`00S`3oool00`000000oooo0?ooo`0L0?oo
o`030000003oool0oooo04H0oooo00<000000?ooo`3oool09P3oool008l0oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo02H0oooo002?0?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0W0?ooo`00S`3o
ool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0:03o
ool008l0oooo0P00000P0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0:03oool0
08l0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo
02T0oooo002?0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0?P3oool00`000000
oooo0?ooo`0Z0?ooo`00S`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo03`0oooo
00<000000?ooo`3oool0:`3oool008l0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?oo
o`0j0?ooo`030000003oool0oooo02`0oooo002?0?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool0>@3oool00`000000oooo0?ooo`0/0?ooo`00S`3oool00`000000oooo0?ooo`0S0?oo
o`030000003oool0oooo03P0oooo00<000000?ooo`3oool0;@3oool008l0oooo00<000000?ooo`3o
ool0903oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo02h0oooo002?0?ooo`800000
9P3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo02l0oooo002?0?ooo`030000003o
ool0oooo02H0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0`0?ooo`00S`3oool0
0`000000oooo0?ooo`0W0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0<@3oool0
08l0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo
0340oooo002?0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0;P3oool00`000000
oooo0?ooo`0b0?ooo`00S`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo02`0oooo
00<000000?ooo`3oool0<`3oool008l0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?oo
o`0Z0?ooo`030000003oool0oooo03@0oooo002?0?ooo`030000003oool0oooo02/0oooo00<00000
0?ooo`3oool0:03oool00`000000oooo0?ooo`0e0?ooo`00S`3oool00`000000oooo0?ooo`0/0?oo
o`030000003oool0oooo02D0oooo0P00000h0?ooo`00S`3oool2000002h0oooo0P00000T0?ooo`03
0000003oool0oooo03P0oooo002?0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0
803oool00`000000oooo0?ooo`0i0?ooo`00S`3oool00`000000oooo0?ooo`0`0?ooo`030000003o
ool0oooo01d0oooo0P00000l0?ooo`00S`3oool00`000000oooo0?ooo`0a0?ooo`800000703oool0
0`000000oooo0?ooo`0l0?ooo`00S`3oool00`000000oooo0?ooo`0c0?ooo`800000603oool20000
03l0oooo002?0?ooo`030000003oool0oooo03D0oooo0`00000C0?ooo`800000@@3oool008l0oooo
00<000000?ooo`3oool0>03oool2000000l0oooo0P0000130?ooo`00QP3oool4000000D0oooo00<0
00000?ooo`3oool0>P3oool2000000X0oooo0`0000150?ooo`00R03oool00`000000oooo0?ooo`04
0?ooo`<00000?03oool:000004P0oooo00280?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0SP3oool008P0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`2>0?ooo`00
R03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo08h0oooo00260?ooo`<000001P3o
ool00`000000oooo0?ooo`2>0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-3.31822, -1.05362, 
  0.0231235, 0.0119094}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(P =. \)], "Input"],

Cell[BoxData[
    \(R := 1\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rho[lat]\)], "Input"],

Cell[BoxData[
    \(\(\((\(-1\) + P)\)\ Cos[lat]\)\/\(P - Sin[lat]\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SL := Evaluate[Solve[rho[lat] == rho, lat]]\)], "Input"],

Cell[BoxData[
    \(Solve::"ifun" \( : \ \) 
      "Inverse functions are being used by \!\(Solve\), so some solutions may \
not be found."\)], "Message"]
}, Open  ]],

Cell[BoxData[
    \(P =. \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[lat /. SL[\([1]\)]] /. {mp\)], "Input"],

Cell[BoxData[
    \(\(-ArcCos[
        \(-\(\((P\ rho - P\^2\ rho + 
                \@\(rho\^2\ \((
                    1 - 2\ P + rho\^2 - P\^2\ \((\(-1\) + rho\^2)\))\)\))\)/
            \((1 - 2\ P + P\^2 + rho\^2)\)\)\)]\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(irho1[rho_] = lat /. SL[\([2]\)]\)], "Input"],

Cell[BoxData[
    \(ArcCos[
      \((\(-P\)\ rho + P\^2\ rho - 
            \[Sqrt]\((
                rho\^2 - 2\ P\ rho\^2 + P\^2\ rho\^2 + rho\^4 - P\^2\ rho\^4)
                \))\)/\((1 - 2\ P + P\^2 + rho\^2)\)]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(irho2[rho_] = \(-\((lat /. SL[\([3]\)])\)\)\)], "Input"],

Cell[BoxData[
    \(ArcCos[
      \((\(-P\)\ rho + P\^2\ rho + 
            \[Sqrt]\((
                rho\^2 - 2\ P\ rho\^2 + P\^2\ rho\^2 + rho\^4 - P\^2\ rho\^4)
                \))\)/\((1 - 2\ P + P\^2 + rho\^2)\)]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(P = 1.707\)], "Input"],

Cell[BoxData[
    StyleBox["1.70700000000000002`",
      StyleBoxAutoDelete->True,
      PrintPrecision->4]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(z[rho_] = 0 \((1 - 2  P + P\^2 + rho\^2)\)\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[{rho[q], rho[irho1[rho[q]]], z[rho[q]], Sin[q] - \((1/P)\)}, {q, 
        0, \[Pi]}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.303152 0.329079 0.536619 [
[.17539 .31658 -9 -9 ]
[.17539 .31658 9 0 ]
[.32696 .31658 -3 -9 ]
[.32696 .31658 3 0 ]
[.47854 .31658 -9 -9 ]
[.47854 .31658 9 0 ]
[.63011 .31658 -3 -9 ]
[.63011 .31658 3 0 ]
[.78169 .31658 -9 -9 ]
[.78169 .31658 9 0 ]
[.93327 .31658 -3 -9 ]
[.93327 .31658 3 0 ]
[.01131 .00711 -24 -4.5 ]
[.01131 .00711 0 4.5 ]
[.01131 .11443 -24 -4.5 ]
[.01131 .11443 0 4.5 ]
[.01131 .22175 -24 -4.5 ]
[.01131 .22175 0 4.5 ]
[.01131 .4364 -18 -4.5 ]
[.01131 .4364 0 4.5 ]
[.01131 .54373 -18 -4.5 ]
[.01131 .54373 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17539 .32908 m
.17539 .33533 L
s
[(0.5)] .17539 .31658 0 1 Mshowa
.32696 .32908 m
.32696 .33533 L
s
[(1)] .32696 .31658 0 1 Mshowa
.47854 .32908 m
.47854 .33533 L
s
[(1.5)] .47854 .31658 0 1 Mshowa
.63011 .32908 m
.63011 .33533 L
s
[(2)] .63011 .31658 0 1 Mshowa
.78169 .32908 m
.78169 .33533 L
s
[(2.5)] .78169 .31658 0 1 Mshowa
.93327 .32908 m
.93327 .33533 L
s
[(3)] .93327 .31658 0 1 Mshowa
.125 Mabswid
.05412 .32908 m
.05412 .33283 L
s
.08444 .32908 m
.08444 .33283 L
s
.11476 .32908 m
.11476 .33283 L
s
.14507 .32908 m
.14507 .33283 L
s
.2057 .32908 m
.2057 .33283 L
s
.23602 .32908 m
.23602 .33283 L
s
.26633 .32908 m
.26633 .33283 L
s
.29665 .32908 m
.29665 .33283 L
s
.35728 .32908 m
.35728 .33283 L
s
.38759 .32908 m
.38759 .33283 L
s
.41791 .32908 m
.41791 .33283 L
s
.44822 .32908 m
.44822 .33283 L
s
.50885 .32908 m
.50885 .33283 L
s
.53917 .32908 m
.53917 .33283 L
s
.56948 .32908 m
.56948 .33283 L
s
.5998 .32908 m
.5998 .33283 L
s
.66043 .32908 m
.66043 .33283 L
s
.69074 .32908 m
.69074 .33283 L
s
.72106 .32908 m
.72106 .33283 L
s
.75138 .32908 m
.75138 .33283 L
s
.81201 .32908 m
.81201 .33283 L
s
.84232 .32908 m
.84232 .33283 L
s
.87264 .32908 m
.87264 .33283 L
s
.90295 .32908 m
.90295 .33283 L
s
.96358 .32908 m
.96358 .33283 L
s
.9939 .32908 m
.9939 .33283 L
s
.25 Mabswid
0 .32908 m
1 .32908 L
s
.02381 .00711 m
.03006 .00711 L
s
[(-0.6)] .01131 .00711 1 0 Mshowa
.02381 .11443 m
.03006 .11443 L
s
[(-0.4)] .01131 .11443 1 0 Mshowa
.02381 .22175 m
.03006 .22175 L
s
[(-0.2)] .01131 .22175 1 0 Mshowa
.02381 .4364 m
.03006 .4364 L
s
[(0.2)] .01131 .4364 1 0 Mshowa
.02381 .54373 m
.03006 .54373 L
s
[(0.4)] .01131 .54373 1 0 Mshowa
.125 Mabswid
.02381 .03394 m
.02756 .03394 L
s
.02381 .06077 m
.02756 .06077 L
s
.02381 .0876 m
.02756 .0876 L
s
.02381 .14126 m
.02756 .14126 L
s
.02381 .16809 m
.02756 .16809 L
s
.02381 .19492 m
.02756 .19492 L
s
.02381 .24859 m
.02756 .24859 L
s
.02381 .27542 m
.02756 .27542 L
s
.02381 .30225 m
.02756 .30225 L
s
.02381 .35591 m
.02756 .35591 L
s
.02381 .38274 m
.02756 .38274 L
s
.02381 .40957 m
.02756 .40957 L
s
.02381 .46323 m
.02756 .46323 L
s
.02381 .49006 m
.02756 .49006 L
s
.02381 .5169 m
.02756 .5169 L
s
.02381 .57056 m
.02756 .57056 L
s
.02381 .59739 m
.02756 .59739 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .55133 m
.06244 .56727 L
.10458 .5826 L
.12507 .58896 L
.14415 .59407 L
.16371 .59832 L
.17333 .59998 L
.18221 .60125 L
.192 .60232 L
.19716 .60273 L
.19979 .6029 L
.20263 .60306 L
.20501 .60316 L
.20719 .60323 L
.20824 .60326 L
.20938 .60328 L
.21046 .6033 L
.21146 .60331 L
.21274 .60332 L
.21394 .60332 L
.21501 .60331 L
.21618 .6033 L
.21745 .60328 L
.21879 .60326 L
.2212 .60318 L
.22375 .60308 L
.22616 .60295 L
.23068 .60263 L
.23555 .60216 L
.24084 .60152 L
.25036 .59996 L
.25917 .59806 L
.27784 .59244 L
.28846 .5882 L
.29844 .5835 L
.33713 .55808 L
.35717 .54013 L
.37827 .51761 L
.41637 .46782 L
.45694 .40398 L
.49598 .33619 L
.53748 .26361 L
.57746 .19941 L
.61593 .1474 L
.63541 .12552 L
.65685 .10512 L
.67744 .08912 L
.69625 .07746 L
.7157 .0682 L
.72654 .0642 L
Mistroke
.73659 .06118 L
.7458 .05897 L
.75561 .05716 L
.76122 .05637 L
.76649 .05579 L
.77123 .05538 L
.7737 .05522 L
.77635 .05508 L
.77893 .05497 L
.78128 .0549 L
.78241 .05488 L
.78364 .05486 L
.78481 .05484 L
.78588 .05484 L
.78712 .05484 L
.78829 .05485 L
.78957 .05486 L
.79029 .05487 L
.79095 .05488 L
.79357 .05495 L
.79489 .055 L
.79633 .05505 L
.80161 .05534 L
.80725 .05577 L
.8174 .05686 L
.82767 .05833 L
.83879 .06032 L
.85895 .06486 L
.89993 .07707 L
.93938 .09161 L
.97619 .10682 L
Mfstroke
.02381 .55133 m
.06244 .56727 L
.10458 .5826 L
.12507 .58896 L
.14415 .59407 L
.16371 .59832 L
.17333 .59998 L
.18221 .60125 L
.192 .60232 L
.19716 .60273 L
.19979 .6029 L
.20263 .60306 L
.20501 .60316 L
.20719 .60323 L
.20824 .60326 L
.20938 .60328 L
.21046 .6033 L
.21146 .60331 L
.21274 .60332 L
.21394 .60332 L
.21501 .60331 L
.21618 .6033 L
.21745 .60328 L
.21879 .60326 L
.2212 .60318 L
.22375 .60308 L
.22616 .60295 L
.23068 .60263 L
.23555 .60216 L
.24084 .60152 L
.25036 .59996 L
.25917 .59806 L
.27784 .59244 L
.28846 .5882 L
.29844 .5835 L
.33713 .55808 L
.35717 .54013 L
.37827 .51761 L
.41637 .46782 L
.45694 .40398 L
.47567 .3719 L
.48554 .35463 L
.49093 .34512 L
.49598 .33619 L
.49853 .33168 L
.49926 .33038 L
.49996 .32915 L
.50127 .32048 L
.50709 .28141 L
.51733 .21676 L
Mistroke
.52709 .1639 L
.53748 .11975 L
.54284 .10206 L
.54789 .08844 L
.55281 .0778 L
.55732 .07012 L
.56163 .06447 L
.56617 .06009 L
.56853 .0584 L
.57073 .05714 L
.57314 .0561 L
.57449 .05567 L
.57572 .05535 L
.57691 .05512 L
.57802 .05497 L
.57924 .05487 L
.58055 .05484 L
.58185 .05488 L
.5825 .05493 L
.58322 .055 L
.58449 .05517 L
.58566 .05539 L
.58799 .05596 L
.59011 .05664 L
.59485 .05862 L
.60554 .06494 L
.61562 .07251 L
.63398 .08822 L
.6444 .09752 L
.64949 .10206 L
.65191 .10419 L
.65297 .10513 L
.65414 .10616 L
.65528 .10648 L
.6565 .10542 L
.65907 .10322 L
.66375 .09937 L
.67405 .09151 L
.69511 .07809 L
.71443 .06872 L
.72439 .06493 L
.73528 .06153 L
.74565 .059 L
.7553 .05721 L
.76064 .05645 L
.76549 .05589 L
.76818 .05563 L
.77109 .05539 L
.77365 .05522 L
.77639 .05507 L
Mistroke
.77894 .05497 L
.78127 .0549 L
.78239 .05488 L
.78361 .05486 L
.78477 .05484 L
.78584 .05484 L
.78649 .05484 L
.7872 .05484 L
.78848 .05485 L
.78973 .05486 L
.79087 .05488 L
.79212 .05491 L
.79349 .05495 L
.79624 .05505 L
.79899 .05518 L
.80149 .05533 L
.80712 .05576 L
.81728 .05684 L
.8272 .05826 L
.83638 .05986 L
.85714 .06441 L
.89643 .0759 L
.9342 .08958 L
.97442 .10606 L
.97619 .10682 L
Mfstroke
.02381 .32908 m
.06244 .32908 L
.10458 .32908 L
.14415 .32908 L
.18221 .32908 L
.22272 .32908 L
.26171 .32908 L
.30316 .32908 L
.34309 .32908 L
.3815 .32908 L
.42237 .32908 L
.46172 .32908 L
.49955 .32908 L
.53984 .32908 L
.57861 .32908 L
.61984 .32908 L
.65954 .32908 L
.69774 .32908 L
.73838 .32908 L
.77751 .32908 L
.81909 .32908 L
.85916 .32908 L
.89771 .32908 L
.93871 .32908 L
.97619 .32908 L
s
.02381 .01472 m
.06244 .08292 L
.10458 .156 L
.14415 .22219 L
.18221 .28252 L
.22272 .34208 L
.26171 .39392 L
.30316 .44213 L
.34309 .48104 L
.3815 .51086 L
.40095 .52294 L
.42237 .53383 L
.44268 .54177 L
.45178 .54456 L
.46172 .54706 L
.4671 .54818 L
.4721 .54906 L
.47727 .54983 L
.48196 .55038 L
.48658 .55081 L
.4887 .55096 L
.49093 .55109 L
.49332 .5512 L
.49438 .55124 L
.49552 .55128 L
.49675 .5513 L
.49789 .55132 L
.49859 .55133 L
.49925 .55133 L
.50049 .55133 L
.50163 .55133 L
.50286 .55131 L
.50401 .55129 L
.50508 .55126 L
.50754 .55117 L
.51014 .55103 L
.51268 .55086 L
.51504 .55067 L
.5204 .55012 L
.5293 .54883 L
.53882 .54694 L
.54906 .54432 L
.56016 .5408 L
.58032 .53261 L
.62123 .50899 L
.66064 .47774 L
.69852 .44032 L
.73886 .3932 L
.77769 .34151 L
.81897 .28071 L
Mistroke
.85873 .21748 L
.89697 .15335 L
.93767 .08272 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo00080?ooo`800000
103oool00`000000oooo0?ooo`030?ooo`8000001@3oool00`000000oooo0?ooo`3o0?ooo`<0oooo
00070?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool200000?l0
oooo103oool000L0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000040?oo
o`030000003oool0oooo0?l0oooo0`3oool000030?ooo`0000000000008000000P3oool010000000
oooo0?ooo`0000080?ooo`<000001@3oool00`000000oooo0?ooo`3j0?ooo`030000003oool0oooo
00D0oooo00070?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool01@3oool20000
0?X0oooo00<000000?ooo`3oool01P3oool000L0oooo00@000000?ooo`3oool00000203oool00`00
0000oooo0?ooo`050?ooo`800000nP3oool00`000000oooo0?ooo`060?ooo`00203oool2000000X0
oooo0`0000040?ooo`030000003oool000000?P0oooo00<000000?ooo`3oool01`3oool001/0oooo
00<000000?ooo`000000n03oool00`000000oooo0?ooo`070?ooo`006`3oool2000000030?ooo`00
0000oooo0?D0oooo00<000000?ooo`3oool0203oool001/0oooo00@000000?ooo`3oool00000mP3o
ool00`000000oooo0?ooo`080?ooo`006`3oool01@000000oooo0?ooo`3oool000000?@0oooo00<0
00000?ooo`3oool02@3oool001/0oooo00D000000?ooo`3oool0oooo0000003d0?ooo`030000003o
ool0oooo00T0oooo000K0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0l03oool0
0`000000oooo0?ooo`0:0?ooo`006`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0>h0oooo00<000000?ooo`3oool02`3oool001/0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`280?ooo`H00000:P3ooolD00000280oooo00<000000?ooo`3oool02`3oool001/0oooo
0P0000050?ooo`030000003oool0oooo08H0oooo0P0000050?ooo`<000008P3oool5000001@0oooo
1`00000J0?ooo`030000003oool0oooo00`0oooo000K0?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0Q@3oool00`000000oooo0?ooo`080?ooo`8000007@3oool6000001`0oooo1@00
000F0?ooo`030000003oool0oooo00`0oooo000K0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0Q03oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01P0oooo0`00000U
0?ooo`@000004P3oool00`000000oooo0?ooo`0=0?ooo`006`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo08<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0E0?oo
o`<00000:`3oool4000000h0oooo00<000000?ooo`3oool03@3oool001/0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`220?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool04P3oool3000002l0oooo1@00000:0?ooo`030000003oool0oooo00h0oooo000K0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo0100oooo0P00000d0?ooo`@00000203oool00`000000oooo0?ooo`0>0?ooo`006`3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo07l0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0=0?ooo`<00000>03oool4000000@0oooo00<000000?ooo`3oool03`3o
ool001/0oooo0P0000090?ooo`030000003oool0oooo07h0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0:0?ooo`<00000?03oool4000000030?ooo`000000oooo0140oooo000K0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`0D0?oo
o`030000003oool0oooo00P0oooo0P0000110?ooo`@000004@3oool001/0oooo00<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo01D0oooo0P0000070?ooo`80
0000@`3oool6000000h0oooo000K0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
N`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
@`3oool010000000oooo0?ooo`3oool4000000`0oooo000K0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool0NP3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00800000
A@3oool00`000000oooo0?ooo`040?ooo`D000002@3oool001/0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo01X0oooo0`0000160?ooo`030000003o
ool0oooo00L0oooo100000070?ooo`00203oool2000000@0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0N03oool0
0`000000oooo0?ooo`0K0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool02P3oool2
000000L0oooo00070?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0;0?ooo`030000003oool0oooo07P0oooo00<000000?ooo`3oool06P3oool0
0`000000oooo0?ooo`150?ooo`030000003oool0oooo01@0oooo00070?ooo`040000003oool0oooo
000000L0oooo1@0000040?ooo`8000003@3oool00`000000oooo0?ooo`1f0?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0D0?ooo`0000<0oooo0000
000000000P0000020?ooo`040000003oool0oooo000000L0oooo00@000000?ooo`3oool000001@3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo07H0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`150?ooo`030000003oool0oooo01D0oooo00070?ooo`040000003oool0
oooo000000P0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo07D0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`160?ooo`030000003o
ool0oooo01D0oooo00070?ooo`040000003oool0oooo000000T0oooo0P0000050?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`0H0?ooo`030000003o
ool0oooo04H0oooo00<000000?ooo`3oool05P3oool000P0oooo0P00000;0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`1d0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`0G0?ooo`006`3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool05P3oool20000
04T0oooo00<000000?ooo`3oool05`3oool001/0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`1b0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`0H0?ooo`006`3oool200000140oooo00<000000?ooo`3oool0L@3oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool0603oool001/0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool0B@3oool00`000000oooo0?ooo`0I0?ooo`006`3oool00`000000oooo0?ooo`0A
0?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`1:
0?ooo`030000003oool0oooo01T0oooo000K0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool0L03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo04T0oooo00<000000?oo
o`3oool06P3oool001/0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`1^0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`0K0?ooo`00
6`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo01/0oooo000K0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo04X0oooo00<000000?ooo`3oool0703oool001/0oooo0P00000E0?ooo`030000003oool0
oooo06`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1:0?ooo`030000003oool0
oooo01`0oooo000K0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0J`3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool07@3oool001/0
oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`0N0?ooo`006`3oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`1:0?ooo`030000003oool0oooo01h0oooo000K0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0J03oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo04X0oooo00<0
00000?ooo`3oool07`3oool001/0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1X
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0O
0?ooo`006`3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo06L0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo0200oooo000K0?ooo`80
00006@3oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0B`3oool00`000000oooo0?ooo`0P0?ooo`006`3oool00`000000oooo0?ooo`0I0?ooo`030000
003oool0oooo06D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1;0?ooo`030000
003oool0oooo0240oooo000K0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0I03o
ool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool08P3o
ool001/0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`1T0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0R0?ooo`006`3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo0680oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`1;0?ooo`030000003oool0oooo02<0oooo000K0?ooo`030000003oool0oooo01`0
oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo04`0
oooo00<000000?ooo`3oool08`3oool000P0oooo0P0000040?ooo`030000003oool0oooo0080oooo
100000040?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0H@3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool0903oool000L0oooo00@0
00000?ooo`3oool00000203oool00`000000oooo0?ooo`050?ooo`8000007P3oool00`000000oooo
0?ooo`1P0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0B`3oool00`000000oooo
0?ooo`0U0?ooo`001`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`0U0?ooo`0000<0oooo0000000000000P00
00020?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`1;0?ooo`030000003oool0oooo02H0oooo00070?ooo`040000003oool0oooo000000/0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo05d0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo02L0oooo
00070?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000103oool00`000000
oooo0?ooo`0O0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`1;0?ooo`030000003oool0oooo02L0oooo00080?ooo`8000002P3oool2000000D0oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0X0?ooo`006`3oool00`000000oooo0?oo
o`0Q0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`1;0?ooo`030000003oool0oooo02T0oooo000K0?ooo`8000008P3oool00`000000oooo0?ooo`1K
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0Y
0?ooo`006`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo05T0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo02X0oooo000K0?ooo`03
0000003oool0oooo02<0oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo04`0oooo00<000000?ooo`3oool0:P3oool001/0oooo00<000000?ooo`3oool0
8`3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
B`3oool00`000000oooo0?ooo`0[0?ooo`006`3oool00`000000oooo0?ooo`0T0?ooo`030000003o
ool0oooo05L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1;0?ooo`030000003o
ool0oooo02`0oooo000K0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0E`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0;03oool0
01/0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0]0?ooo`006`3oool2000002L0
oooo00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo04/0
oooo00<000000?ooo`3oool0;P3oool001/0oooo00<000000?ooo`3oool09P3oool00`000000oooo
0?ooo`1D0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0B`3oool00`000000oooo
0?ooo`0^0?ooo`006`3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo05<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo02l0oooo000K
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool0<03oool001/0oooo00<000000?oo
o`3oool0:03oool00`000000oooo0?ooo`1B0?ooo`050000003oool0oooo0?ooo`000000C@3oool0
0`000000oooo0?ooo`0`0?ooo`006`3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo
0540oooo00D000000?ooo`3oool0oooo0000001<0?ooo`030000003oool0oooo0340oooo000K0?oo
o`030000003oool0oooo01h0oooo0P0000040?ooo`030000003oool0oooo0080oooo0`00000O0?oo
o`@000007`3oool4000000<0oooo00<000000?ooo`3oool00P3oool400000080oooo00<000000?oo
o`3oool06@3oool4000001h0oooo100000030?ooo`030000003oool0oooo0080oooo1000000P0?oo
o`8000004P3oool001/0oooo00<000000?ooo`3oool07@3oool010000000oooo0?ooo`0000090?oo
o`030000003oool000000200oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0:0?oo
o`040000003oool0oooo000001/0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo01d0oooo00@000000?ooo`3oool000004@3oool001/0oooo0P00000N
0?ooo`040000003oool0oooo000000X0oooo0P00000P0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool02@3oool2000000030?ooo`000000oooo01`0oooo00<000000?ooo`3oool07`3o
ool00`000000oooo0?ooo`0:0?ooo`8000008P3oool00`000000oooo0?ooo`0?0?ooo`006`3oool0
0`000000oooo0?ooo`0M0?ooo`040000003oool0oooo000000P0oooo1000000P0?ooo`030000003o
ool0oooo0200oooo00<000000?ooo`3oool01`3oool3000000030?ooo`000000oooo01h0oooo00<0
00000?ooo`3oool07`3oool00`000000oooo0?ooo`070?ooo`<000008@3oool200000180oooo000K
0?ooo`030000003oool0oooo01d0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`00000P0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool01`3oool01@000000oooo
0000003oool000000200oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`060?ooo`80
0000903oool00`000000oooo0?ooo`0?0?ooo`006`3oool00`000000oooo0?ooo`0M0?ooo`040000
003oool0oooo000000P0oooo00D000000?ooo`3oool0oooo0000000M0?ooo`<00000803oool30000
00T0oooo00@000000?ooo`00000000007P3oool010000000oooo0?ooo`00000N0?ooo`040000003o
ool0oooo000000P0oooo00<000000?ooo`3oool0803oool010000000oooo0?ooo`00000A0?ooo`00
6`3oool00`000000oooo0?ooo`0N0?ooo`8000002@3oool4000000030?ooo`000000oooo01d0oooo
00<000000?ooo`3oool0803oool00`000000oooo0?ooo`070?ooo`@000007`3oool200000200oooo
0P0000080?ooo`D00000803oool200000180oooo000K0?ooo`030000003oool0oooo02l0oooo00<0
00000?ooo`3oool0BP3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo03L0oooo000K
0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0B@3oool2000004/0oooo00<00000
0?ooo`3oool0=`3oool001@0ooooo`00000=000000006`3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool00000
00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool01@3oool100000040oooo0@3oool001/0oooo00<000000?oo
o`3oool0<@3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo04T0oooo00<000000?oo
o`3oool0>@3oool001/0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`140?ooo`80
0000BP3oool00`000000oooo0?ooo`0j0?ooo`006`3oool00`000000oooo0?ooo`0c0?ooo`030000
003oool0oooo04<0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`0k0?ooo`006`3o
ool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0480oooo0P00001:0?ooo`030000003o
ool0oooo03/0oooo000K0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0@@3oool0
0`000000oooo0?ooo`180?ooo`030000003oool0oooo03`0oooo000K0?ooo`800000=P3oool00`00
0000oooo0?ooo`0o0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0?@3oool001/0
oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo04L0
oooo00<000000?ooo`3oool0?P3oool001/0oooo00<000000?ooo`3oool0=P3oool00`000000oooo
0?ooo`0m0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0?P3oool001/0oooo00<0
00000?ooo`3oool0=`3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo04L0oooo00<0
00000?ooo`3oool0?`3oool001/0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0j
0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0@03oool001/0oooo00<000000?oo
o`3oool0>03oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo04P0oooo00<000000?oo
o`3oool0@03oool001/0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0h0?ooo`03
0000003oool0oooo04L0oooo00<000000?ooo`3oool0@@3oool001/0oooo0P00000k0?ooo`030000
003oool0oooo03H0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`120?ooo`006`3o
ool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0AP3o
ool00`000000oooo0?ooo`130?ooo`006`3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0
oooo03@0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`130?ooo`006`3oool00`00
0000oooo0?ooo`0l0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0AP3oool00`00
0000oooo0?ooo`140?ooo`006`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo0340
oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`150?ooo`006`3oool00`000000oooo
0?ooo`0n0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0A@3oool00`000000oooo
0?ooo`160?ooo`006`3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo02h0oooo00<0
00000?ooo`3oool0A@3oool00`000000oooo0?ooo`170?ooo`006`3oool200000400oooo00<00000
0?ooo`3oool0;@3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo04P0oooo000K0?oo
o`030000003oool0oooo0400oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`140?oo
o`030000003oool0oooo04T0oooo000K0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3o
ool0:P3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo04T0oooo000K0?ooo`030000
003oool0oooo0480oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`150?ooo`030000
003oool0oooo04X0oooo000K0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`140?ooo`030000003oool0oooo04/0oooo000K0?ooo`030000003oool0
oooo04@0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`140?ooo`030000003oool0
oooo04`0oooo00080?ooo`800000103oool00`000000oooo0?ooo`020?ooo`@00000103oool00`00
0000oooo0?ooo`140?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0A03oool00`00
0000oooo0?ooo`1=0?ooo`001`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo
00D0oooo0P0000160?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0@`3oool00`00
0000oooo0?ooo`1>0?ooo`001`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
04<0oooo00<000000?ooo`3oool0C`3oool000L0oooo00@000000?ooo`3oool000002P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0803oool00`00
0000oooo0?ooo`120?ooo`030000003oool0oooo0500oooo00070?ooo`040000003oool0oooo0000
00/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
01h0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`1A0?ooo`001`3oool010000000
oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0B@3oool0
0`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0DP3oool0
00P0oooo0P00000:0?ooo`8000001@3oool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo
01/0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`1C0?ooo`006`3oool00`000000
oooo0?ooo`1;0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0@@3oool00`000000
oooo0?ooo`1D0?ooo`006`3oool2000004d0oooo0P00000H0?ooo`030000003oool0oooo0440oooo
00<000000?ooo`3oool0E@3oool001/0oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0EP3oool001/0oooo00<00000
0?ooo`3oool0C`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0400oooo00<00000
0?ooo`3oool0E`3oool001/0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo0400oooo00<000000?ooo`3oool0F03oool001/0oooo00<000000?ooo`3o
ool0D@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3o
ool0F@3oool001/0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo03l0oooo00<000000?ooo`3oool0FP3oool001/0oooo00<000000?ooo`3oool0D`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0F`3o
ool001/0oooo0P00001E0?ooo`8000002`3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0
oooo05`0oooo000K0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0n0?ooo`800000G`3oool001/0oooo00<000000?ooo`3oool0E`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0G`3oool001/0oooo
00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo03d0oooo
00<000000?ooo`3oool0H03oool001/0oooo00<000000?ooo`3oool0F@3oool2000000<0oooo00<0
00000?ooo`3oool0?@3oool00`000000oooo0?ooo`1Q0?ooo`006`3oool00`000000oooo0?ooo`1K
0?ooo`030000003oool0000003l0oooo00<000000?ooo`3oool0HP3oool001/0oooo00<000000?oo
o`3oool0G03oool2000003h0oooo00<000000?ooo`3oool0H`3oool001/0oooo00<000000?ooo`3o
ool0G03oool3000003/0oooo0P00001V0?ooo`006`3oool2000005`0oooo00@000000?ooo`3oool0
oooo0P00000g0?ooo`800000J03oool001/0oooo00<000000?ooo`3oool0FP3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo0380oooo0P00001Z0?ooo`006`3oool00`000000oooo0?oo
o`1I0?ooo`030000003oool0oooo00H0oooo0P00000`0?ooo`800000K03oool001/0oooo00<00000
0?ooo`3oool0F@3oool00`000000oooo0?ooo`080?ooo`800000;03oool2000006h0oooo000K0?oo
o`030000003oool0oooo05P0oooo00<000000?ooo`3oool02`3oool3000002L0oooo0P00001`0?oo
o`00203oool2000000@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo05L0oooo00<000000?ooo`3oool03`3oool2000002<0oooo0P00001b0?ooo`00
1`3oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0EP3oool00`000000oooo0?ooo`0B0?ooo`<000007@3oool3000007@0oooo00070?ooo`040000
003oool0oooo000000L0oooo1@0000040?ooo`800000EP3oool00`000000oooo0?ooo`0F0?ooo`80
0000603oool3000007L0oooo00070?ooo`040000003oool0oooo000000L0oooo00@000000?ooo`3o
ool000001@3oool00`000000oooo0?ooo`1C0?ooo`8000006`3oool6000000X0oooo2000001j0?oo
o`001`3oool010000000oooo0?ooo`0000080?ooo`030000003oool0000000D0oooo0P00001C0?oo
o`030000003oool0oooo0240oooo2P0000220?ooo`001`3oool010000000oooo0?ooo`0000090?oo
o`8000001@3oool010000000oooo00000000001@0?ooo`030000003oool0oooo0:h0oooo00080?oo
o`8000002`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo0?ooo`<00000C03oool0
0`000000oooo0?ooo`2_0?ooo`006`3oool00`000000oooo0?ooo`040?ooo`800000B03oool20000
0;80oooo000K0?ooo`030000003oool0oooo00H0oooo0`0000130?ooo`800000]03oool001/0oooo
0P00000:0?ooo`<00000?`3oool00`000000oooo0?ooo`2d0?ooo`006`3oool00`000000oooo0?oo
o`0<0?ooo`800000>`3oool200000;L0oooo000K0?ooo`030000003oool0oooo00h0oooo0`00000f
0?ooo`800000^@3oool001/0oooo00<000000?ooo`3oool04@3oool300000380oooo00<000000?oo
o`3oool0^@3oool001/0oooo00<000000?ooo`3oool0503oool3000002d0oooo0P00002l0?ooo`00
6`3oool00`000000oooo0?ooo`0G0?ooo`@000009`3oool200000;h0oooo000K0?ooo`030000003o
ool0oooo01/0oooo1@00000N0?ooo`@00000`03oool001/0oooo0P00000Q0?ooo`@000005P3oool4
00000<@0oooo000K0?ooo`030000003oool0oooo02@0oooo200000080?ooo`H00000b03oool001/0
oooo00<000000?ooo`3oool0;03oool800000<h0oooo000K0?ooo`030000003oool0oooo0?l0oooo
0`3oool001/0oooo00<000000?ooo`3oool0o`3oool30?ooo`006`3oool00`000000oooo0?ooo`3o
0?ooo`<0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.338866, -0.6663, 
  0.0124008, 0.00700556}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(P =. \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CF = {rho\^4 -> rho4, rho\^2 -> rho2, P\^2 -> mp2, P -> mp}\)], "Input"],

Cell[BoxData[
    \({rho\^4 \[Rule] rho4, rho\^2 \[Rule] rho2, P\^2 \[Rule] mp2, 
      P \[Rule] mp}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CForm[irho1[rho] /. CF]\)], "Input"],

Cell["\<\
ArcCos((-(mp*rho) + mp2*rho - 
      Sqrt(rho2 - 2*mp*rho2 + 
        mp2*rho2 + rho4 - mp2*rho4))/
    (1 - 2*mp + mp2 + rho2))\
\>", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CForm[irho2[rho] /. CF]\)], "Input"],

Cell["\<\
ArcCos((-(mp*rho) + mp2*rho + 
      Sqrt(rho2 - 2*mp*rho2 + 
        mp2*rho2 + rho4 - mp2*rho4))/
    (1 - 2*mp + mp2 + rho2))\
\>", "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CForm[rho[lat] /. CF]\)], "Input"],

Cell["((-1 + mp)*Cos(lat))/(mp - Sin(lat))", "Output"]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1312}, {0, 1024}},
WindowSize->{520, 600},
WindowMargins->{{Automatic, 228}, {Automatic, 78}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 43, 1, 32, "Input"],
Cell[1755, 52, 41, 1, 32, "Input"],
Cell[1799, 55, 90, 1, 61, "Input"],
Cell[1892, 58, 68, 1, 32, "Input"],
Cell[1963, 61, 73, 1, 32, "Input"],

Cell[CellGroupData[{
Cell[2061, 66, 39, 1, 32, "Input"],
Cell[2103, 69, 55, 1, 32, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2195, 75, 90, 1, 55, "Input"],
Cell[2288, 78, 26836, 688, 186, 6149, 428, "GraphicsData", 
"PostScript", "Graphics"],
Cell[29127, 768, 130, 3, 32, "Output"]
}, Open  ]],
Cell[29272, 774, 38, 1, 32, "Input"],
Cell[29313, 777, 39, 1, 32, "Input"],

Cell[CellGroupData[{
Cell[29377, 782, 41, 1, 32, "Input"],
Cell[29421, 785, 82, 1, 55, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29540, 791, 76, 1, 55, "Input"],
Cell[29619, 794, 154, 3, 74, "Message"]
}, Open  ]],
Cell[29788, 800, 38, 1, 32, "Input"],

Cell[CellGroupData[{
Cell[29851, 805, 68, 1, 32, "Input"],
Cell[29922, 808, 241, 5, 150, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30200, 818, 65, 1, 32, "Input"],
Cell[30268, 821, 232, 5, 99, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30537, 831, 76, 1, 32, "Input"],
Cell[30616, 834, 232, 5, 99, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30885, 844, 42, 1, 32, "Input"],
Cell[30930, 847, 119, 3, 32, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31086, 855, 75, 1, 40, "Input"],
Cell[31164, 858, 35, 1, 32, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31236, 864, 122, 2, 78, "Input"],
Cell[31361, 868, 30829, 823, 186, 7942, 536, "GraphicsData", 
"PostScript", "Graphics"],
Cell[62193, 1693, 130, 3, 32, "Output"]
}, Open  ]],
Cell[62338, 1699, 38, 1, 32, "Input"],

Cell[CellGroupData[{
Cell[62401, 1704, 92, 1, 68, "Input"],
Cell[62496, 1707, 115, 2, 39, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[62648, 1714, 56, 1, 32, "Input"],
Cell[62707, 1717, 154, 5, 104, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[62898, 1727, 56, 1, 32, "Input"],
Cell[62957, 1730, 154, 5, 104, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[63148, 1740, 54, 1, 32, "Input"],
Cell[63205, 1743, 54, 0, 44, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

