/*
 * ppmice.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] = "$Id: join.c,v 1.5 2002/08/23 08:35:08 root Exp $";

/*
 * $Log: join.c,v $
 * Revision 1.5  2002/08/23 08:35:08  root
 * #
 *
 * Revision 1.4  2002/08/23 08:35:04  root
 * #
 *
 * Revision 1.3  2002/08/21 23:02:37  root
 * #
 *
 * Revision 1.2  2002/08/21 16:04:15  root
 * #
 *
 * Revision 1.1  2002/08/21 16:04:07  root
 * #
 *
 * Revision 1.1  2002/08/21 12:07:29  root
 * #
 *
 * Revision 1.2  2002/08/21 09:40:55  root
 * #
 *
 */

/*  join.c


*/

#include <math.h>
#include "ppm.h"

#include "ice.h"

#include "size.h"

int
main (argc, argv)
     int argc;
     char *argv[];
{
  FILE *ifp, *afp = NULL;

  pixel **epixels, **ipixels, **cpixels, **opixels;
  int er, eg, eb, icer, iceg, iceb;
  pixval maxval;


#define WHITEN(r,g,b,w) r+=(((255-r)*w)/255), g+=(((255-g)*w)/255), b+=(((255-b)*w)/255)
#define SLEW(r,g,b,e,f,h,w) r=((r*(255-w))+(w*e))/255, g=((g*(255-w))+(w*f))/255, b=((b*(255-w))+(w*h))/255


  int x, y;
  int w, h;
  int cloud;

  ppm_init (&argc, argv);

  ifp = fopen (argv[3], "r");
  ipixels = ppm_readppm (ifp, &w, &h, &maxval);
  pm_close (ifp);

  ifp = fopen (argv[2], "r");
  cpixels = ppm_readppm (ifp, &w, &h, &maxval);
  pm_close (ifp);

  ifp = fopen (argv[1], "r");
  epixels = ppm_readppm (ifp, &w, &h, &maxval);
  pm_close (ifp);

  opixels = ppm_allocarray (OWIDTH, OHEIGHT);
  maxval = 255;


  for (y = 0; y < OHEIGHT; ++y)
    {
      for (x = 0; x < OWIDTH; ++x)
        {
          er = PPM_GETR (epixels[y][x]);
          eg = PPM_GETG (epixels[y][x]);
          eb = PPM_GETB (epixels[y][x]);

          icer = PPM_GETR (ipixels[y][x]);
          iceg = PPM_GETG (ipixels[y][x]);
          iceb = PPM_GETB (ipixels[y][x]);

          cloud = PPM_GETG (cpixels[y][x]);

/*
  	  cloud=2*(cloud-128);
	  if (cloud<0) cloud=0;
*/


          if (iceg)
            {
              if (er < ICER)
                er += ((ICER - er) * icer) / ICER;
              if (eg < ICEG)
                eg += ((ICEG - eg) * iceg) / ICEG;
              if (eb < ICEB)
                eb += ((ICEB - eb) * iceb) / ICEB;

            }

          WHITEN (er, eg, eb, cloud);



          PPM_ASSIGN (opixels[y][x], er, eg, eb);

        }
    }


  ppm_writeppm (stdout, opixels, OWIDTH, OHEIGHT, maxval, 0);
  pm_close (stdout);
  exit (0);
}
