/*
 * mergesats.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] =
  "$Id: mergesats.c,v 1.9 2002/08/26 09:41:06 root Exp root $";

/*
 * $Log: mergesats.c,v $
 * Revision 1.9  2002/08/26 09:41:06  root
 * #
 *
 * Revision 1.8  2002/08/24 13:45:45  root
 * #
 *
 * Revision 1.7  2002/08/24 08:08:48  root
 * #
 *
 * Revision 1.6  2002/08/23 18:51:25  root
 * #
 *
 * Revision 1.5  2002/08/23 17:03:58  root
 * #
 *
 * Revision 1.4  2002/08/23 08:35:08  root
 * #
 *
 * Revision 1.3  2002/08/23 08:35:04  root
 * #
 *
 * Revision 1.2  2002/08/21 23:02:37  root
 * #
 *
 * Revision 1.1  2002/08/21 21:22:44  root
 * #
 *
 * Revision 1.2  2002/08/21 16:04:15  root
 * #
 *
 * Revision 1.1  2002/08/21 16:04:07  root
 * #
 *
 * Revision 1.1  2002/08/21 12:07:29  root
 * #
 *
 * Revision 1.2  2002/08/21 09:40:55  root
 * #
 *
 */

/*  join.c


*/

#include <math.h>
#include "ppm.h"

#include "size.h"

#define POLAR 180

#define N 5

int
main (argc, argv)
     int argc;
     char *argv[];
{
  FILE *ifp, *afp = NULL;


  int shift[N];
  double dshift[N] = { 0, 75, -140, 135, -63 /*,0 */  };

  char *names[N] = { argv[1], argv[2], argv[3], argv[4], argv[5] };

/* "NOBACKUP/AI.pc.he.pgm", "NOBACKUP/EI.pc.he.pgm", "NOBACKUP/JI.pc.he.pgm",
"NOBACKUP/WI.pc.he.pgm", "NOBACKUP/XI.pc.he.pgm" ,"NOBACKUP/PO.pc.he.pgm"};*/

  gray **pixels[N], g, maxval, **opixels, **fpixels, **ppixels;
  int i;
  long p;
  int x, y;
  int w, h;
  int n;

  ppm_init (&argc, argv);

  for (i = 0; i < N; ++i)
    {
      ifp = pm_openr (names[i]);
      pixels[i] = pgm_readpgm (ifp, &w, &h, &maxval);
      pm_close (ifp);

      shift[i] = (int) (((dshift[i]) / 360.0) * (double) OWIDTH);

      fprintf (stderr, "%s at %f shifted %d\n", names[i], dshift[i],
               shift[i]);

      while (shift[i] < 0)
        shift[i] += OWIDTH;

    }

  opixels = pgm_allocarray (OWIDTH, OHEIGHT);
  maxval = 255;

  ifp = pm_openr (argv[6]);
  fpixels = pgm_readpgm (ifp, &w, &h, &maxval);
  pm_close (ifp);

  if (argc == 8)
    {

      ifp = pm_openr (argv[7]);
      ppixels = pgm_readpgm (ifp, &w, &h, &maxval);
      pm_close (ifp);

      fprintf (stderr, "And a fudge at the pole\n");

    }
  else
    {
      ppixels = NULL;
    }

  for (y = 0; y < OHEIGHT; ++y)
    {
      for (x = 0; x < OWIDTH; ++x)
        {
          p = 0;
          n = 0;
          for (i = 0; i < N; ++i)
            {
              int qx = x + shift[i];
              int f;

              while (qx > OWIDTH)
                qx -= OWIDTH;

              f = fpixels[y][qx];
              g = pixels[i][y][qx];
              if (g != 255)
                {
                  p += (f * g);
                  n += f;
                }


            }
          if (ppixels)
            {
              int f = ppixels[y][x];
              p += (f * POLAR);
              n += f;
            }

          if (n)
            {
              p = p / n;
              if (p > 255)
                p = 255;

              opixels[y][x] = p;
            }
          else
            {
              opixels[y][x] = 255;
            }

        }
    }


  pgm_writepgm (stdout, opixels, OWIDTH, OHEIGHT, maxval, 0);
  pm_close (stdout);
  exit (0);
}
