/*
 * ppmice.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] =
  "$Id: night.c,v 1.1 2002/08/26 09:41:06 root Exp root $";

/*
 * $Log: night.c,v $
 * Revision 1.1  2002/08/26 09:41:06  root
 * #
 *
 * Revision 1.10  2002/08/24 13:38:11  root
 * #
 *
 * Revision 1.9  2002/08/24 08:08:48  root
 * #
 *
 * Revision 1.8  2002/08/23 18:51:25  root
 * #
 *
 * Revision 1.7  2002/08/23 17:03:58  root
 * #
 *
 * Revision 1.6  2002/08/23 08:35:08  root
 * #
 *
 * Revision 1.5  2002/08/23 08:35:04  root
 * #
 *
 * Revision 1.4  2002/08/21 23:02:37  root
 * #
 *
 * Revision 1.3  2002/08/21 21:22:44  root
 * #
 *
 * Revision 1.2  2002/08/21 16:04:15  root
 * #
 *
 * Revision 1.1  2002/08/21 12:07:29  root
 * #
 *
 * Revision 1.2  2002/08/21 09:40:55  root
 * #
 *
 */

/*  ppmpc.c

    Project Earth image in Mollweide projection to rectangular
    Mercator bitmap.

    Based on the projection code from the GCTPc package, developed
    by the EROS Data Center.  GCTPc is available from the following
    FTP sites:

	ftp://edcftp.cr.usgs.gov/pub/software/gctpc/gctpc.tar.Z
	ftp://charon.er.usgs.gov/pub/S.gctpc.tar.Z

*/

#include "ppm.h"


#include "size.h"

#define SLEW(r,g,b,e,f,h,w) r=((r*(255-w))+(w*e))/255, g=((g*(255-w))+(w*f))/255, b=((b*(255-w))+(w*h))/255

int
main (argc, argv)
     int argc;
     char *argv[];
{
  FILE *ifp, *afp = NULL;

  pixel **ipixels, **opixels;
  pixel **lpixels;
  pixval maxval;

  int x, y;
  int w, h;

  int argn;
  char *usage =
    "[-dim <num>] [-red <num>] [-green <num>] [-blue <num>] [pbmfile]";

  ppm_init (&argc, argv);

  argn = 1;

  while (argn < argc && argv[argn][0] == '-' && argv[argn][1] != '\0')
    {
      pm_usage (usage);
      ++argn;
    }

  ifp = pm_openr (argv[1]);
  ipixels = ppm_readppm (ifp, &w, &h, &maxval);
  pm_close (ifp);

  ifp = pm_openr (argv[2]);
  lpixels = ppm_readppm (ifp, &w, &h, &maxval);
  pm_close (ifp);

  opixels = ppm_allocarray (OWIDTH, OHEIGHT);
  maxval = 255;



  for (y = 0; y < OHEIGHT; ++y)
    {

      for (x = 0; x < OWIDTH; ++x)
        {
          int r = PPM_GETR (ipixels[y][x]);
          int g = PPM_GETG (ipixels[y][x]);
          int b = PPM_GETB (ipixels[y][x]);
          int l = PPM_GETG (lpixels[y][x]);
          r = r / 9;
          g = g / 9;
          b = b / 6;
          l = l * 2;
          if (l > 255)
            l = 255;
          SLEW (r, g, b, 200, 200, 99, l);
          PPM_ASSIGN (opixels[y][x], r, g, b);

        }
    }

  ppm_writeppm (stdout, opixels, OWIDTH, OHEIGHT, maxval, 0);
  pm_close (stdout);
  exit (0);
}
