#include <stdio.h>

#define MN 100
#define BS 10240

FILE *out;
FILE *in[MN];
unsigned char buf[BS];
unsigned char c[BS];



main (int argc, char *argv[])
{
  int i;
  int n, r, tr;
  int x, y;


  argc--;
  argv++;

  if (argc > MN)
    {
      fprintf (stderr, "FISH!\n");
      exit (1);
    }

  for (i = 0; i < argc; ++i)
    {
      in[i] = fopen (argv[i], "r");
      fgets (buf, sizeof (buf), in[i]); /*header */
      if (!i)
        fputs (buf, stdout);
      fgets (buf, sizeof (buf), in[i]);
      if (!i)
        fputs (buf, stdout);
      sscanf (buf, "%d %d", &x, &y);
      n = x * y;
      fgets (buf, sizeof (buf), in[i]);
      if (!i)
        fputs (buf, stdout);
    }

  fprintf (stderr, "%d frames of %d bytes\n", argc, n);

  while (n)
    {
      unsigned char *cptr;
      unsigned char *bptr;
      memset (c, 255, sizeof (c));

      tr = n > BS ? BS : n;

      for (i = 0; i < argc; ++i)
        {
          bptr = buf;
          cptr = c;
          r = fread (buf, 1, tr, in[i]);
          while (r--)
            {
              if (*bptr < *cptr)
                *cptr = *bptr;
              bptr++;
              cptr++;
            }
        }

      bptr = buf;
      cptr = c;
      r = tr;
      while (r--)
        *(bptr++) = *(cptr++);

      fwrite (buf, 1, tr, stdout);

      n -= tr;
    }


  for (i = 0; i < argc; ++i)
    fclose (in[i]);



}
