/*
 * ppmice.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] =
  "$Id: ppmice.c,v 1.11 2002/08/26 09:41:06 root Exp root $";

/*
 * $Log: ppmice.c,v $
 * Revision 1.11  2002/08/26 09:41:06  root
 * #
 *
 * Revision 1.10  2002/08/24 13:38:11  root
 * #
 *
 * Revision 1.9  2002/08/24 08:08:48  root
 * #
 *
 * Revision 1.8  2002/08/23 18:51:25  root
 * #
 *
 * Revision 1.7  2002/08/23 17:03:58  root
 * #
 *
 * Revision 1.6  2002/08/23 08:35:08  root
 * #
 *
 * Revision 1.5  2002/08/23 08:35:04  root
 * #
 *
 * Revision 1.4  2002/08/21 23:02:37  root
 * #
 *
 * Revision 1.3  2002/08/21 21:22:44  root
 * #
 *
 * Revision 1.2  2002/08/21 16:04:15  root
 * #
 *
 * Revision 1.1  2002/08/21 12:07:29  root
 * #
 *
 * Revision 1.2  2002/08/21 09:40:55  root
 * #
 *
 */

/*  ppmpc.c

    Project Earth image in Mollweide projection to rectangular
    Mercator bitmap.

    Based on the projection code from the GCTPc package, developed
    by the EROS Data Center.  GCTPc is available from the following
    FTP sites:

	ftp://edcftp.cr.usgs.gov/pub/software/gctpc/gctpc.tar.Z
	ftp://charon.er.usgs.gov/pub/S.gctpc.tar.Z

*/

#include <math.h>
#include "ppm.h"
#include "ice.h"

#define EPSLN	1.0e-10

#include "size.h"


typedef struct
{
  double x;
  double y;
  double sx;
  double sy;
}
Pc;

int
pc (Pc * m, double lat, double lon, double *x, double *y)
{

  while (lon < -180.0)
    lon += 180.0;
  while (lon > 180.0)
    lon -= 180.0;

  *x = (m->x) + ((m->sx) * lon);
  *y = (m->y) - ((m->sy) * lat);

}

init_pc (Pc * m)
{
  int mx = 540;
  int my = 270;
  int lx = 45;
           /*-165*/
  int ty = 45;                  /*75 */


  m->x = (double) mx;
  m->y = (double) my;

  m->sy = ((double) (my - ty)) / 75.0;
  m->sx = ((double) (mx - lx)) / 165.0;

}


int
main (argc, argv)
     int argc;
     char *argv[];
{
  FILE *ifp, *afp = NULL;

  pixel **ipixels, **opixels;
  gray **expixels;
  pixval maxval;

  Pc m;
  int x, y;
  int w, h;

  int argn;
  char *usage =
    "[-dim <num>] [-red <num>] [-green <num>] [-blue <num>] [pbmfile]";


  ppm_init (&argc, argv);

  argn = 1;

  while (argn < argc && argv[argn][0] == '-' && argv[argn][1] != '\0')
    {
      pm_usage (usage);
      ++argn;
    }

  ifp = pm_openr (argv[1]);
  ipixels = ppm_readppm (ifp, &w, &h, &maxval);
  pm_close (ifp);

  ifp = pm_openr (argv[2]);
  expixels = pgm_readpgm (ifp, &w, &h, &maxval);
  pm_close (ifp);


  init_pc (&m);


  opixels = ppm_allocarray (OWIDTH, OHEIGHT);
  maxval = 255;

#define ISDUD(x,y) (( (PPM_GETR(ipixels[y][x])==0) && (PPM_GETG(ipixels[y][x])==0) && (PPM_GETB(ipixels[y][x])==0)) ? 1:0 )
#define ISICE(x,y) (( (PPM_GETR(ipixels[y][x])==220) && (PPM_GETG(ipixels[y][x])==220) && (PPM_GETB(ipixels[y][x])==220)) ? 1:0 )


  for (y = 0; y < OHEIGHT; ++y)
    {
      double lat =
        90.0 * ((double) ((OHEIGHT / 2) - y)) / ((double) (OHEIGHT / 2));

      for (x = 0; x < OWIDTH; ++x)
        {
          double lon =
            180.0 * ((double) (x - (OWIDTH / 2))) / ((double) (OWIDTH / 2));
          double mx, my;
          int ix, iy;
          int ice;

          pc (&m, lat, lon, &mx, &my);



          ix = (int) (mx + .5);
          iy = (int) (my + .5);
          while (ix < 0)
            ix += w;
          if (iy < 0)
            iy = 0;
          while (ix >= w)
            ix -= w;
          if (iy >= h)
            iy = h - 1;


          if (ISDUD (ix, iy))
            {
              int sx, sy, sn = 0;
              ice = 0;
              for (sy = -2; sy < 3; sy += 1)
                {
                  int qy = sy + iy;
                  if ((qy >= 0) && (qy < h))
                    {
                      for (sx = -2; sx < 3; sx += 1)
                        {
                          int qx = sx + ix;
                          while (qx < 0)
                            qx += w;
                          while (qx >= w)
                            qx -= w;


                          ice += ISICE (qx, qy);
                          sn++;

                        }
                    }
                }


              if ((ice * 2) >= sn)
                {
                  ice = 1;
                }
              else
                {
                  ice = 0;
                }

            }
          else
            {
              ice = ISICE (ix, iy);
            }
          if (iy > 495)
            ice = 0;

          if ((ix > 1) && (ix < 6))
            ice = 0;

          if (ice)
            PPM_ASSIGN (opixels[y][x], ICER, ICEG, ICEB);
          else
            PPM_ASSIGN (opixels[y][x], 0, 0, 0);

          if (y < 25)
            PPM_ASSIGN (opixels[y][x], ICER, ICEG, ICEB);

          if (expixels[y][x])
            PPM_ASSIGN (opixels[y][x], ICER, ICEG, ICEB);

        }
    }

  for (y = 0; y < OHEIGHT; ++y)
    {
      int l = PPM_GETG (opixels[y][1]);
      int r = PPM_GETG (opixels[y][13]);

      for (x = 3; x < 13; ++x)
        {

          if (l && r)
            PPM_ASSIGN (opixels[y][x], ICER, ICEG, ICEB);
          if (l && (x < 8))
            PPM_ASSIGN (opixels[y][x], ICER, ICEG, ICEB);
          if (r && (x > 7))
            PPM_ASSIGN (opixels[y][x], ICER, ICEG, ICEB);



        }
    }

  ppm_writeppm (stdout, opixels, OWIDTH, OHEIGHT, maxval, 0);
  pm_close (stdout);
  exit (0);
}
