/*
 * ppmice.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] = "$Id: ppmle.c,v 1.9 2002/08/24 13:45:45 root Exp $";

/*
 * $Log: ppmle.c,v $
 * Revision 1.9  2002/08/24 13:45:45  root
 * #
 *
 * Revision 1.8  2002/08/24 13:38:11  root
 * #
 *
 * Revision 1.7  2002/08/23 18:51:25  root
 * #
 *
 * Revision 1.6  2002/08/23 17:03:58  root
 * #
 *
 * Revision 1.5  2002/08/23 08:35:08  root
 * #
 *
 * Revision 1.4  2002/08/23 08:35:04  root
 * #
 *
 * Revision 1.3  2002/08/21 21:22:44  root
 * #
 *
 * Revision 1.2  2002/08/21 16:04:15  root
 * #
 *
 * Revision 1.1  2002/08/21 16:04:07  root
 * #
 *
 * Revision 1.1  2002/08/21 12:07:29  root
 * #
 *
 * Revision 1.2  2002/08/21 09:40:55  root
 * #
 *
 */

/*  ppmpc.c

    Project Earth image in Mollweide projection to rectangular
    Mercator bitmap.

    Based on the projection code from the GCTPc package, developed
    by the EROS Data Center.  GCTPc is available from the following
    FTP sites:

	ftp://edcftp.cr.usgs.gov/pub/software/gctpc/gctpc.tar.Z
	ftp://charon.er.usgs.gov/pub/S.gctpc.tar.Z

*/

#include <math.h>
#include "ppm.h"

#define EPSLN	1.0e-10

#include "size.h"


typedef struct
{
  double x;
  double y;
  double sx;
  double sy;
}
Pc;

int
pc (Pc * m, double lat, double lon, double *x, double *y)
{

  while (lon < -180.0)
    lon += 180.0;
  while (lon > 180.0)
    lon -= 180.0;

  *x = (m->x) + ((m->sx) * lon);
  *y = (m->y) - ((m->sy) * lat);

}

init_pc (Pc * m, int w, int h)
{
  int mx = (w + 1) / 2;
  int my = (h + 1) / 2;
  int lx = 0;
           /*-165*/
  int ty = 0;                   /*75 */


  m->x = (double) mx;
  m->y = (double) my;

  m->sy = ((double) (my - ty)) / 90.0;
  m->sx = ((double) (mx - lx)) / 180.0;

}


int
main (argc, argv)
     int argc;
     char *argv[];
{
  FILE *ifp, *afp = NULL;

  pixel **ipixels, **opixels;
  pixval maxval;

  Pc m;
  int x, y;
  int w, h;

  int argn;
  char *usage =
    "[-dim <num>] [-red <num>] [-green <num>] [-blue <num>] [pbmfile]";


  ppm_init (&argc, argv);

  argn = 1;

  while (argn < argc && argv[argn][0] == '-' && argv[argn][1] != '\0')
    {
      pm_usage (usage);
      ++argn;
    }

  if (argn != argc)
    {
      ifp = pm_openr (argv[argn]);
      ++argn;
    }
  else
    ifp = stdin;

  if (argn != argc)
    pm_usage (usage);



  ipixels = ppm_readppm (ifp, &w, &h, &maxval);
  pm_close (ifp);
  init_pc (&m, w, h);

  opixels = ppm_allocarray (OWIDTH, OHEIGHT);
  maxval = 255;



  for (y = 0; y < OHEIGHT; ++y)
    {
      double lat =
        90.0 * ((double) ((OHEIGHT / 2) - y)) / ((double) (OHEIGHT / 2));

      for (x = 0; x < OWIDTH; ++x)
        {
          double lon =
            180.0 * ((double) (x - (OWIDTH / 2))) / ((double) (OWIDTH / 2));
          double mx, my;
          int ix, iy;
          int ice;

          pc (&m, lat, lon, &mx, &my);


          ix = (int) (mx + .5);
          iy = (int) (my + .5);
          while (ix < 0)
            ix += w;
          if (iy < 0)
            iy = 0;
          while (ix >= w)
            ix -= w;
          if (iy >= h)
            iy = h - 1;



          opixels[y][x] = ipixels[iy][ix];


        }
    }


  ppm_writeppm (stdout, opixels, OWIDTH, OHEIGHT, maxval, 0);
  pm_close (stdout);
  exit (0);
}
