/*
 * ppmice.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] = "$Id: rembkg.c,v 1.7 2002/08/24 13:45:45 root Exp $";

/*
 * $Log: rembkg.c,v $
 * Revision 1.7  2002/08/24 13:45:45  root
 * #
 *
 * Revision 1.6  2002/08/24 13:38:11  root
 * #
 *
 * Revision 1.5  2002/08/23 18:51:25  root
 * #
 *
 * Revision 1.4  2002/08/23 17:03:58  root
 * #
 *
 * Revision 1.3  2002/08/23 13:42:28  root
 * #
 *
 * Revision 1.2  2002/08/23 08:35:08  root
 * #
 *
 * Revision 1.1  2002/08/23 08:35:04  root
 * #
 *
 * Revision 1.3  2002/08/21 23:02:37  root
 * #
 *
 * Revision 1.2  2002/08/21 16:04:15  root
 * #
 *
 * Revision 1.1  2002/08/21 16:04:07  root
 * #
 *
 * Revision 1.1  2002/08/21 12:07:29  root
 * #
 *
 * Revision 1.2  2002/08/21 09:40:55  root
 * #
 *
 */

/*  join.c


*/

#include <math.h>
#include "ppm.h"

#include "ice.h"

#include "size.h"

int
main (argc, argv)
     int argc;
     char *argv[];
{
  FILE *ifp, *afp = NULL;

  gray **ipixels, **bpixels, **tpixels, **apixels, **opixels;
  int ig, bg, og, tg, ag;
  gray maxval;


  int x, y;
  int w, h;
  int cloud;

  ppm_init (&argc, argv);

  ifp = fopen (argv[1], "r");
  ipixels = pgm_readpgm (ifp, &w, &h, &maxval);
  pm_close (ifp);

  ifp = fopen (argv[2], "r");
  bpixels = pgm_readpgm (ifp, &w, &h, &maxval);
  pm_close (ifp);


  ifp = fopen (argv[3], "r");
  tpixels = pgm_readpgm (ifp, &w, &h, &maxval);
  pm_close (ifp);

  ifp = fopen (argv[4], "r");
  apixels = pgm_readpgm (ifp, &w, &h, &maxval);
  pm_close (ifp);

  opixels = pgm_allocarray (OWIDTH, OHEIGHT);
  maxval = 255;


  for (y = 0; y < OHEIGHT; ++y)
    {
      for (x = 0; x < OWIDTH; ++x)
        {
          ig = (ipixels[y][x]);
          bg = (bpixels[y][x]);
          tg = (tpixels[y][x]);
          ag = (apixels[y][x]);

          if ((bg > 250) || (ig < 1))
            {
              og = 200;
            }
#if 1
          else
            {
              og = ig;
            }
#else
          else if (ig <= bg)
            {
              og = 0;
            }
          else if (ig >= tg)
            {
              og = 255;
            }
          else if (ig == ag)
            {
              og = 128;
            }
          else if (ig < ag)
            {
              if (bg == ag)
                {
                  og = bg;
                }
              else
                {
                  og = (128 * (ig - bg)) / (ag - bg);
                }
            }
          else if (ig > ag)
            {
              if (tg == ag)
                {
                  og = tg;
                }
              else
                {
                  og = 128 + ((127 * (ig - ag)) / (tg - ag));
                }

            }
#endif
          if (og > 255)
            og = 255;
          if (og < 0)
            og = 0;

          opixels[y][x] = og;

        }
    }

  pgm_writepgm (stdout, opixels, OWIDTH, OHEIGHT, maxval, 0);
  pm_close (stdout);
  exit (0);
}
