/*
 * satcamera.c: convert lat/long to geostationary satellite camera coords
 *
 * Copyright (c) 2000 Chris Lightfoot. All rights reserved.
 *
 * $Log: satcamera.c,v $
 * Revision 1.4  2002/08/23 13:42:28  root
 * #
 *
 * Revision 1.3  2002/08/23 08:35:04  root
 * #
 *
 * Revision 1.2  2002/08/21 23:02:37  root
 * #
 *
 * Revision 1.1  2002/08/21 21:22:44  root
 * #
 *
 *
 */

static char rcsid[] = "$Id: satcamera.c,v 1.4 2002/08/23 13:42:28 root Exp $";

#include <math.h>
#include "satcamera.h"

#define PI	3.141592654

#define CX	SCSIZE
#define CY	SCSIZE
#define MARGIN	SCMARGIN

#define RADIUS_EARTH	6378.273   /* kilometers */
#define ALTITUDE	42169.440

void
satcam_forward (double lon, double lat, double *x, double *y)
{
  const double rho = ALTITUDE / RADIUS_EARTH;
  const double d = rho * (CX / 2 - MARGIN);

  /* This works using a projection from the 3-space containing the earth
   * and the satellite into screen coordinates, effectively.
   */

  *x = (CX / 2) + d * cos (lat) * sin (lon) / (rho - cos (lat) * cos (lon));
  *y = (CY / 2) - d * sin (lat) / (rho - cos (lat) * cos (lon));
}
