/*
 * satcamtopc.c: map IR satellite pictures onto a Plate Caree projection
 *
 * Copyright (c) 2000 Chris Lightfoot. All rights reserved.
 *
 * $Log: satcamtopc.c,v $
 * Revision 1.6  2002/08/24 13:38:11  root
 * #
 *
 * Revision 1.5  2002/08/23 17:03:58  root
 * #
 *
 * Revision 1.4  2002/08/23 08:35:08  root
 * #
 *
 * Revision 1.3  2002/08/23 08:35:04  root
 * #
 *
 * Revision 1.2  2002/08/21 23:02:37  root
 * #
 *
 * Revision 1.1  2002/08/21 21:22:44  root
 * #
 *
 *
 */

static char rcsid[] =
  "$Id: satcamtopc.c,v 1.6 2002/08/24 13:38:11 root Exp $";

#include <string.h>
#include <stdio.h>
#include <errno.h>
#include <pgm.h>
#include <math.h>
#include <time.h>

#include "size.h"
#include "satcamera.h"

#include "polar-stereo.h"

#define PROGNAME	"satcamtopc"

#define IGNORE_THRESHOLD	0      //120

#define THRESH			160

void
Error (char *s)
{
  fprintf (stderr, PROGNAME ": %s: %s\n", s, strerror (errno));
  exit (1);
}

#define PI 		3.141592654
#define PIXELSIZE	25.0

int
main (int argc, char **argv)
{
  gray **sat_image, **pc_image, **bsat_image;
  int img_format;
  gray maxval;
  int pc_cx, pc_cy, sat_cx, sat_cy;
  char *sat_file;
  FILE *fp;
  gray *row;
  int i, j, x, y, f, g;

  if (argc != 2)
    {
      fprintf (stderr,
               PROGNAME
               ": need to specify satellite pgm and width/height of Plate Caree image\n");
      return 1;
    }
  sat_file = argv[1];

  pc_cx = OWIDTH;
  pc_cy = OHEIGHT;

  if (pc_cx < 1 || pc_cy < 1)
    {
      fprintf (stderr,
               PROGNAME
               ": need to correctly specify Plate Caree image width/height\n");
      return 1;
    }
  /* Read in the polar maps */
  fp = fopen (argv[1], "r");
  if (!fp)
    Error (sat_file);
  sat_image = pgm_readpgm (fp, &sat_cx, &sat_cy, &maxval);
  fprintf (stderr, "%s: %d x %d pixels\n", sat_file, sat_cx, sat_cy);
  fclose (fp);

  /* Generate PC map and write it out */
  row = pgm_allocrow (pc_cx);

  pgm_writepgminit (stdout, pc_cx, pc_cy, maxval, 0);

  for (y = 0; y < pc_cy; y++)
    {
      double lat, lon, X, Y, xx, yy, xf, yf;
      int x1, y1;
      double z1, z2, z3, z4, r, g, b;

      lat = (0.5 - (double) y / (double) pc_cy) * PI;

      memset (row, 255, pc_cx * sizeof (gray));

      satcam_forward (0.0, lat, &xx, &yy);

      for (x = 0; x < pc_cx; x++)
        {
          lon = ((double) x / (double) pc_cx - 0.5) * 2. * PI;

          if (lon < PI / 2. && lon > -PI / 2.)
            {
              double dx, dy;

              satcam_forward (lon, lat, &xx, &yy);

              x1 = (int) (xx + .5);
              y1 = (int) (yy + .5);

              dx = xx - sat_cx / 2;
              dy = yy - sat_cy / 2;

              if (((dx * dx) + (dy * dy)) < (SCD * SCD))
                {
                  if (y1 == sat_cy - 1)
                    y1--;
/*
                  xf = xx - floor (xx);
                  yf = yy - floor (yy);

                  z1 = sat_image[y1][x1];
                  z2 = sat_image[y1][x1 + 1];
                  z3 = sat_image[y1 + 1][x1 + 1];
                  z4 = sat_image[y1 + 1][x1];

                  row[x] =
                    (gray) ((1. - xf) * (1 - yf) * z1 + xf * (1. - yf) * z2 +
                            xf * yf * z3 + (1. - xf) * yf * z4);

                  if (row[x] < IGNORE_THRESHOLD)
                    row[x] = 0;
*/

                  row[x] = (int) sat_image[y1][x1];


                }
              else
                row[x] = 255;
            }
          else
            row[x] = 255;
        }

      pgm_writepgmrow (stdout, row, pc_cx, maxval, 0);

    }

  fprintf (stderr, "\n");

  return 0;
}
