/* -*- Mode: C++; c-basic-offset: 8 -*-
 * gfishtime.c - A cheap xfishtime ripoff.
 * Copyright (C) 1999 Dave Camp
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>
#include <gnome.h>
#include <applet-widget.h>
#include <libgnomeui/gnome-window-icon.h>
#include <math.h>
#include <stdio.h>

#define INPANEL 1

#include "gfishtime.h"


#undef VERSION
#define main old_main
#include "wmfishtime/fishmon.c"
#undef main


#define UPDATE_TIMEOUT 25

FishtimeApplet fishtime_applet = { 0 };
guint timeout_handle = -1;


static gint
timer_cb (void)
{


  fishmon_update ();
  gdk_draw_rgb_image (fishtime_applet.canvas->window,
                      bm.gc,
                      4, 4, 56, 56, GDK_RGB_DITHER_NONE, bm.rgb, 56 * 3);


  return TRUE;
}

void
destroy_fishtime (void)
{

  gtk_widget_destroy (fishtime_applet.canvas);
}



void
create_fishtime (void)
{



  fishtime_applet.canvas = gtk_drawing_area_new ();

  if (fishtime_applet.canvas == NULL)
    {
      g_error ("Error creating gfishtime\n");
      exit (1);
    }

  gtk_drawing_area_size (GTK_DRAWING_AREA (fishtime_applet.canvas), 64, 64);

  gtk_widget_show (fishtime_applet.canvas);


  applet_widget_add (APPLET_WIDGET (fishtime_applet.applet),
                     fishtime_applet.canvas);
  gtk_widget_show (fishtime_applet.canvas);

  bm.gc = gdk_gc_new (fishtime_applet.canvas->window);

}

static gint
delete_cb (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  gtk_timeout_remove (timeout_handle);
  timeout_handle = -1;
  return FALSE;
}

static gint
enter_cb (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  int ch;
  proximity = 1;
  for (ch = 0; ch < NRFISH; ch++)
    bm.fishes[ch].speed += (rand () % 2) + 1;

  return FALSE;
}

static gint
leave_cb (GtkWidget * widget, GdkEvent * event, gpointer data)
{
  int ch;
  proximity = 0;
  /* get fish moving again, but slowly - checking out */
  for (ch = 0; ch < NRFISH; ch++)
    bm.fishes[ch].speed = 1;

  return FALSE;
}


static void
create_fishtime_applet (void)
{
  fishtime_applet.applet = applet_widget_new ("gfishtime_applet");

  if (!fishtime_applet.applet)
    g_error ("Can't create applet!\n");

  gtk_signal_connect (GTK_OBJECT (fishtime_applet.applet),
                      "delete_event", GTK_SIGNAL_FUNC (delete_cb), NULL);

  gtk_signal_connect (GTK_OBJECT (fishtime_applet.applet),
                      "enter_notify_event", GTK_SIGNAL_FUNC (enter_cb), NULL);

  gtk_signal_connect (GTK_OBJECT (fishtime_applet.applet),
                      "leave_notify_event", GTK_SIGNAL_FUNC (leave_cb), NULL);


  gtk_widget_realize (fishtime_applet.applet);
}

int
main (int argc, char *argv[])
{


  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);

  srand (time (NULL));
  memset (&bm, 0, sizeof (bm));
  bubble_state_change = (YMAX / 4);
  prepare_sprites ();
  prepare_backbuffer (0);

  applet_widget_init ("gfishtime_applet", VERSION, argc, argv, NULL, 0, NULL);
  gnome_window_icon_set_default_from_file (GNOME_ICONDIR
                                           "/gnome-fishtime.png");
  create_fishtime_applet ();
  create_fishtime ();

  timeout_handle = gtk_timeout_add (UPDATE_TIMEOUT, (void *) timer_cb, NULL);

  gtk_widget_show (fishtime_applet.applet);

  applet_widget_gtk_main ();

  return 0;
}
