int
system_battery (void)
{
  static int i, update;
  FILE *stat;

  if (i == -1)
    return i;

  if (--update > 0)
    return i;

  update = 50;

  stat = fopen ("/proc/apm", "r");
  if (!stat)
    {
      i = -1;
      return i;
    }
  fscanf (stat, "%*s %*s %*s %*s %*s %*s %d", &i);
  fclose (stat);


  return i;
}


/* returns current CPU load in percent, 0 to 100 */
int
system_cpu (void)
{
  static unsigned int cpuload;
  u_int64_t load, total;
  static u_int64_t oload, ototal;
#ifdef __alpha__
  unsigned long long ab, ac, ad, ae;
#else
  u_int64_t ab, ac, ad, ae;
#endif
  FILE *stat;
  static int update;

  if (--update > 0)
    {
      return cpuload;
    }
  update = 10;


  stat = fopen ("/proc/stat", "r");
  fscanf (stat, "%*s %Ld %Ld %Ld %Ld", &ab, &ac, &ad, &ae);
  fclose (stat);

  /* Find out the CPU load */
  /* user + sys = load
   * total = total */
  load = ab;                    //+ ac + ad; /* cpu.user + cpu.sys; */
  total = ab + ac + ad + ae;    /* cpu.total; */

  /*
     Because the load returned from libgtop is a value accumulated
     over time, and not the current load, the current load percentage
     is calculated as the extra amount of work that has been performed
     since the last sample. yah, right, what the fuck does that mean?
   */
  if (ototal == 0)              /* ototal == 0 means that this is the first time
                                   we get here */
    cpuload = 0;
  else
    {
      cpuload *= 60;
      cpuload = cpuload / 100;
      cpuload += (40 * (load - oload)) / (total - ototal);
    }

  oload = load;
  ototal = total;

  return cpuload;
}

int
system_memory (void)
{
  u_int64_t my_mem_used, my_mem_max;
  u_int64_t my_swap_used, my_swap_max;

  static int mem_delay = 0;
  FILE *mem;
#ifdef __alpha__
  static unsigned long long aa, ab, ac, ad, ae, af, ag, ah;
#else
  static u_int64_t aa, ab, ac, ad, ae, af, ag, ah;
#endif
  /* put this in permanent storage instead of stack */
  static char shit[2048];

  /* we might as well get both swap and memory at the same time.
   * sure beats opening the same file twice */
  if (mem_delay-- <= 0)
    {
      mem = fopen ("/proc/meminfo", "r");
      fgets (shit, 2048, mem);

      fscanf (mem, "%*s %Ld %Ld %Ld %Ld %Ld %Ld", &aa, &ab, &ac,
              &ad, &ae, &af);
      fscanf (mem, "%*s %Ld %Ld", &ag, &ah);
      fclose (mem);
      mem_delay = 25;

      /* calculate it */
      my_mem_max = aa;          /* memory.total; */
      my_swap_max = ag;         /* swap.total; */

      my_mem_used = ah + ab - af - ae; /* swap.used + memory.used - memory.cached - memory.buffer; */

      if (my_mem_used > my_mem_max)
        {
          my_swap_used = my_mem_used - my_mem_max;
          my_mem_used = my_mem_max;
        }
      else
        {
          my_swap_used = 0;
        }

#if 0
      bm.mem_used = my_mem_used;
      bm.mem_max = my_mem_max;
      bm.swap_used = my_swap_used;
      bm.swap_max = my_swap_max;
#endif

      /* memory info changed - update things */
      return 1;
    }
  /* nothing new */
  return 0;
}

void
system_loadavg (void)
{
#if 0
  FILE *avg;
  static int avg_delay;
  if (avg_delay-- <= 0)
    {
      avg = fopen ("/proc/loadavg", "r");
      fscanf (avg, "%d.%d %d.%d %d.%d", &bm.loadavg[0].i, &bm.loadavg[0].f,
              &bm.loadavg[1].i, &bm.loadavg[1].f,
              &bm.loadavg[2].i, &bm.loadavg[2].f);
      fclose (avg);
      avg_delay = ROLLVALUE;
    }
#endif
}



#define FISH_MAX_SPEED	8
#define DIFF_MIN 10

// The actual speed for the fish...
static int tx_speed;
static int rx_speed;

static u_int64_t tx_amount;
static u_int64_t rx_amount;

// Store the last one to compare
static u_int64_t last_tx_amount;
static u_int64_t last_rx_amount;

// Store the max for scaling, too.
static u_int64_t max_tx_diff = DIFF_MIN;
static u_int64_t max_rx_diff = DIFF_MIN;


// The cnt for scaling
static int tx_cnt;
static int rx_cnt;
static int delay;

extern int fish_traffic;
void get_traffic (void);

int
net_tx_speed (void)
{
  get_traffic ();
  return tx_speed;
}


int
net_rx_speed (void)
{
  return rx_speed;
}


int fish_traffic = 0;

void
get_traffic (void)
{
  FILE *dev;
  char buffer[256];
  u_int64_t diff;

  // Have some delay in updating/sampling traffic...
  if (delay++ < 5)
    {
      return;
    }
  else
    {
      delay = 0;
    }

  if ((dev = fopen ("/proc/net/dev", "r")) == NULL)
    {
      // Sanity check
      fish_traffic = 0;
    }
  else
    {
      rx_amount = tx_amount = 0;

      // Don't care about the first 2 lines
      fgets (buffer, 256, dev);
      fgets (buffer, 256, dev);

      while (fgets (buffer, 256, dev))
        {
          char name[256];
#ifdef __alpha__
	  unsigned long long rxa,txa;
#else
          u_int64_t rxa, txa;
#endif


          // I love sscanf! :)
          sscanf (buffer,
                  "%*[ ]%[^:]:%*d %Ld %*d %*d %*d %*d %*d %*d %*d %Ld %*d %*d %*d %*d %*d %*d",
                  name, &rxa, &txa);

          rx_amount += rxa;
          tx_amount += txa;
        }


      // Incoming traffic
      if (rx_amount != last_rx_amount)
        {
          if (last_rx_amount == 0)
            {
              last_rx_amount = rx_amount;
            }

          diff = rx_amount - last_rx_amount;
          last_rx_amount = rx_amount;
          rx_speed = FISH_MAX_SPEED * diff / max_rx_diff;
          if (rx_speed == 0)
            {
              // At least, make it move a bit, cos we know there's
              // traffic
              rx_speed = 1;
            }

          // Do something to max rate, to do proper (hopefully)
          // scaling
          if (max_rx_diff < diff)
            {
              max_rx_diff = diff;
            }
          else
            {
              // Slowly lower the scale
              if (++rx_cnt > 5)
                {
                  max_rx_diff = diff;
                  if (max_rx_diff < DIFF_MIN)
                    {
                      // And don't scale it too low
                      max_rx_diff = DIFF_MIN;
                    }
                  rx_cnt = 0;
                }
            }
        }
      else
        {
          rx_speed = 0;
        }


      // Outgoing traffic
      if (tx_amount != last_tx_amount)
        {
          if (last_tx_amount == 0)
            {
              last_tx_amount = tx_amount;
            }
          diff = tx_amount - last_tx_amount;
          last_tx_amount = tx_amount;
          tx_speed = FISH_MAX_SPEED * diff / max_tx_diff;
          if (tx_speed == 0)
            {
              // At least, make it move a bit, cos we know there's
              // traffic
              tx_speed = 1;
            }

          // Do something to max rate, to do proper (hopefully)
          // scaling
          if (max_tx_diff < diff)
            {
              max_tx_diff = diff;
            }
          else
            {
              // Slowly lower the scale
              if (++tx_cnt > 5)
                {
                  max_tx_diff = diff;
                  if (max_tx_diff < DIFF_MIN)
                    {
                      // And don't scale it too low
                      max_tx_diff = DIFF_MIN;
                    }
                  tx_cnt = 0;
                }
            }
        }
      else
        {
          tx_speed = 0;
        }



    }
  fclose (dev);

}
