/*
 * tcp2stdio.c:
 *
 * Copyright (c) 2001 James McKenzie <james@fishsoup.dhs.org>,
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

static char rcsid[] =
    "$Id: tcp2stdio.c,v 1.5 2002/09/27 10:58:34 root Exp $";

/*
 * $Log: tcp2stdio.c,v $
 * Revision 1.5  2002/09/27 10:58:34  root
 * #
 *
 * Revision 1.4  2002/09/27 10:51:16  root
 * *** empty log message ***
 *
 * Revision 1.3  2002/09/27 10:50:09  root
 * *** empty log message ***
 *
 * Revision 1.2  2001/10/25 16:53:47  root
 * *** empty log message ***
 *
 */

#include <fcntl.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/ip.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <termios.h>
#include <unistd.h>

void gp_turn_off_canonical_mode_and_echo()
{
  int fd = 0;
  struct termios tios;

  tcgetattr(fd, &tios);
  tios.c_iflag = IGNBRK | IGNPAR;
  tios.c_lflag &= ~ICANON;
  tios.c_lflag &= ~ECHO;
  tios.c_cc[VMIN] = 1;
  tios.c_cc[VTIME] = 0;

  tcsetattr(fd, TCSAFLUSH, &tios);
}



int main(int argc, char *argv[])
{
  struct sockaddr_in me, dest;
  int fd;
  unsigned char buf;
  fd_set rd;
  struct hostent *hp;
  struct servent *sp;
  int port;

  signal(SIGPIPE, SIG_IGN);

  if (argc != 3) {
    fprintf(stderr, "Usage %s hostname port\n", argv[0]);
    exit(1);
  }


  hp = gethostbyname(argv[1]);

  if (!hp) {
    fprintf(stderr, "Host %s unknown\n", argv[1]);
    exit(1);
  }

  sp = getservbyname(argv[2], "tcp");
  if (sp) {
    port = ntohs(sp->s_port);
  } else {
    port = atoi(argv[2]);
  }


  if (!port) {
    fprintf(stderr, "Service %s unknown\n", argv[2]);
    exit(1);
  }

  dest.sin_family = AF_INET;
  memcpy((void *) &dest.sin_addr, (void *) hp->h_addr, hp->h_length);
  dest.sin_port = htons(port);

  me.sin_family = AF_INET;
  me.sin_addr.s_addr = INADDR_ANY;
  me.sin_port = htons(0);


  fd = socket(PF_INET, SOCK_STREAM, 0);
  if (fd < 0) {
    perror("socket");
    exit(1);
  }

  if (bind(fd, (struct sockaddr *) &me, sizeof(me))) {
    perror("bind");
    exit(1);
  }

  while (connect(fd, (struct sockaddr *) &dest, sizeof(dest))) {
    perror("(will retry) connect");
    sleep(1);
  }

  gp_turn_off_canonical_mode_and_echo();

  while (1) {
    FD_ZERO(&rd);
    FD_SET(0, &rd);
    FD_SET(fd, &rd);
    select(fd + 1, &rd, NULL, NULL, NULL);

    if (FD_ISSET(0, &rd)) {
      if (read(0, &buf, 1) == 1) {
        if (write(fd, &buf, 1) != 1) {
          perror("write(socket) failed");
          exit(1);
        }
      } else {
        perror("read(stdin) failed");
        exit(1);
      }

    }

    if (FD_ISSET(fd, &rd)) {
      if (read(fd, &buf, 1) == 1) {
        if (write(1, &buf, 1) != 1) {
          perror("write(stdout) failed");
          exit(1);
        }

      } else {
        perror("read(socket) failed");
        exit(1);
      }
    }
  }







}
