static char rcsid[] = "$Id: neostat.c,v 1.1 2000/01/06 02:26:44 root Exp $";

/* Neomagic panel/CRT detection code, no warranty whatsoever no implied */
/* warranty use entriely at your own risk. */
/* (C) 2000 James McKenzie <james@fishsoup.dhs.org> */

/* This code must be compiled with gcc -O2 */

/*
 * $Log: neostat.c,v $
 * Revision 1.1  2000/01/06 02:26:44  root
 * Initial revision
 *
 */

#include <asm/io.h>

#define GRAX 0x3ce


int 
main (int argc, char *argv[])
{
  int state;
  int grax;
  int lock;

  printf ("neomagic state: %s\n", rcsid);
  printf ("(C) 2000 James McKenzie, No warranty express or implied. "
	"Use at your own risk\n");

  iopl (3);                     /*Enable cli/sti and in/out */

  __asm__ __volatile__ (" cli ");

  grax = inb (GRAX); /*Store grax index*/
  
  outb (0x9, GRAX);  /*index=lock*/
  lock=inb(GRAX+1);  /*=data*/

  outb (0x9, GRAX);  /*index=lock*/
  outb (0x26,GRAX+1); /*data=0x26*/

  outb (0x20, GRAX);
  state = inb (GRAX + 1) & 3;

  outb (0x9, GRAX);  /*index=lock*/
  outb (lock, GRAX+1); 

  outb (grax, GRAX);

  __asm__ __volatile__ (" sti ");

  printf ("neomagic: ");

  switch (state)
    {
    case 0x0:
      printf ("no display enabled\n");
      break;
    case 0x1:
      printf ("CRT enabled\n");
      break;
    case 0x2:
      printf ("LCD enabled\n");
      break;
    case 0x3:
      printf ("LCD and CRT enabled\n");
      break;
    }

  printf("neomagic is ");
  switch(lock) 
   {
   case 0x0:
     printf("locked\n");
	break;
   case 0x26:
     printf("unlocked\n");
	break;
	default:
     printf("confused\n");
   }

  return state;

}
