//----------------------------------------------------------------------------------------
// Name:        blocked_dialog.h
// Purpose:     Add/edit a blocked string for exclusion lists dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: blocked_dialog.h,v 1.5 2001/12/25 04:54:30 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _BLOCKED_DIALOG_H_
#define _BLOCKED_DIALOG_H_

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#include "wx/dialog.h"
#include "wx/listctrl.h"

//----------------------------------------------------------------------------------------
// Define a new dialog type
//----------------------------------------------------------------------------------------

class blocked_dialog : public wxDialog
{
public:      
    void controls_init();
    // Override base class functions
    void OnOK( wxCommandEvent& event );
    // Member variables
    wxListCtrl*     m_selected_listctrl;
    long            m_selected_item_id;
private:
    DECLARE_EVENT_TABLE()
};

//----------------------------------------------------------------------------------------
// External functions and variables
//----------------------------------------------------------------------------------------

extern blocked_dialog*     the_blocked_dialog;
void init_a_blocked_dialog( wxWindow* parent, wxListCtrl* selected_listctrl, long selected_item_id );

#endif  //_BLOCKED_DIALOG_H_

