//----------------------------------------------------------------------------------------
// Name:        body_dialog.cpp
// Purpose:     Insert a body dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: body_dialog.cpp,v 1.1 2002/01/04 03:34:27 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "body_dialog.cpp"
    #pragma interface "body_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "body_dialog.h"
#include "editor_dialog.h"
#include "utils_controls.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

body_dialog* the_body_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event body: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( body_dialog, wxDialog )
    EVT_BUTTON( XMLID( "body_dialog_text_color_button" ), body_dialog::on_text_color_button )
    EVT_BUTTON( XMLID( "body_dialog_link_color_button" ), body_dialog::on_link_color_button )
    EVT_BUTTON( wxID_CONTEXT_HELP, body_dialog::on_help_button )
    EVT_BUTTON( wxID_OK, body_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_body_dialog( wxWindow* parent )
{
    the_body_dialog = new body_dialog;
    wxTheXmlResource->LoadDialog( the_body_dialog, parent, "body_dialog" );    
    
    the_body_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------


void body_dialog::on_text_color_button( wxCommandEvent &event )
{
    // [utils_controls.cpp]    
    textctrl_hex_color_selection( XMLCTRL( *the_body_dialog, "body_dialog_text_color_textctrl", wxTextCtrl ) );
}


void body_dialog::on_link_color_button( wxCommandEvent &event )
{
    // [utils_controls.cpp]    
    textctrl_hex_color_selection( XMLCTRL( *the_body_dialog, "body_dialog_link_color_textctrl", wxTextCtrl ) );
}


void body_dialog::on_help_button( wxCommandEvent &event )
{

}


// Override wxDialog's default behavior for clicking an OK button.
void body_dialog::OnOK( wxCommandEvent& event )
{
    wxString output_string;
   
    output_string += "<body";       

    wxString text_color_string = XMLCTRL( *the_body_dialog, "body_dialog_text_color_textctrl", wxTextCtrl )->GetValue();
    if ( text_color_string != "" ) {
        output_string += " text=\"" + text_color_string + "\"";
    }     
    
    wxString link_color_string = XMLCTRL( *the_body_dialog, "body_dialog_link_color_textctrl", wxTextCtrl )->GetValue();
    if ( link_color_string != "" ) {
        output_string += " link=\"" + link_color_string + "\"";
    }     
    
    output_string += ">\n";
    
    the_editor_dialog->stc_or_textctrl_insert_text( output_string, "</body>", TRUE );
    
    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}