//----------------------------------------------------------------------------------------
// Name:        configuration.cpp
// Purpose:     Handles saving and loading of configuration settings
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor
// Licence:     GPL
// RCS-ID:      $Id: configuration.cpp,v 1.4 2001/11/28 01:15:36 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "configuration.cpp"
    #pragma interface "configuration.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "configuration.h"
#include "plucker-desktop.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

wxFileConfig *the_configuration = NULL;

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_configuration()
{
    wxString config_file;
    
    // TODO: set this to where it will be  
#ifdef __WXGTK__
    config_file = wxGetHomeDir() << "/.";    
#else
    config_file = wxGetCwd() << '/';    
#endif
    config_file = config_file << "plucker" << get_configuration_extension();    
    the_configuration = new wxFileConfig( "Plucker Desktop",
        "The Plucker Team", config_file, wxEmptyString,
        wxCONFIG_USE_LOCAL_FILE );
    wxLogDebug( "String for main configuration is %s", config_file.c_str() ); 
    
    // Sets the configuration to the currently active one.
    wxConfigBase::Set( the_configuration );
   
    // Write the version string to the preferences
    the_configuration->Write( "/PLUCKER-DESKTOP/plucker-desktop_version", PLUCKER_DESKTOP_VERSION_STRING );
}

// Delete the configuration object when finished program, otherwise memory leak
void finish_configuration()
{
   if ( the_configuration ) {
      wxConfigBase::Set( NULL );
      delete the_configuration;
      the_configuration = NULL;
   }
}

// Returns the proper extension type for the OS. Linux returns 'rc', Windows returns .ini
// Used when need to make a config file, like pluckerrc or plucker.ini
wxString get_configuration_extension()
{
    wxString extension = ".ini"; 
       
    #ifdef __WXMSW__
        extension = ".ini";
    #endif

    // Mac usually is " Preferences" extension, but that is painful to work with
    #ifdef __WXMAC__
        extension = ".ini";
    #endif
    
    #ifdef __WXGTK__
        extension ="rc";
    #endif
    
    return extension;   
}

// Look up what the group (section) inside the plucker configuration file
// should be for this os. For example exclusion_lists are under [POSIX],
// [WINDOWS], etc.
wxString get_os_configuration_section()
{   
    wxString section = "DEFAULT";
    
    #ifdef __WXMSW__
        section = "WINDOWS";
    #endif

    #ifdef __WXMAC__
        section = "MACINTOSH";
    #endif
    
    #ifdef __WXGTK__
        section ="POSIX";
    #endif
    
    return section;
}

// Checks to see if it is a channel section of the config file, ie not one
// of [DEFAULT], [POSIX], [MACINTOSH], [PLUCKER-DESKTOP], etc.
bool is_channel_configuration_section( wxString section )
{   
    wxString key;
        
    // Create a list of known non-channel strings. Need to call the last one as NULL.
    // NON_CHANNEL_SECTIONS was defined in configuration.h
    wxStringList *strings = new wxStringList( NON_CHANNEL_SECTIONS , NULL );
    // Check to see whether the section passed is a member of the list of strings
    // If is in list of non-channel sections, then isn't a channel section.
    if ( strings->Member( section ) ) {
        return FALSE;
    } else {    
        // Now check to see that there is a home_url key in this section. If there isn't,
        // then it is just a modifier section (like "Sunday" in the comics examples).
        key = section << '/' << "home_url";
        if ( the_configuration->HasEntry( key ) ) {
            return TRUE;   
        } else {
            return FALSE;
        }    
    }
    // TODO: Does the stringlist get destroyed automatically, or do I have to get rid
    // of it?
}

// Looks up the directory for whatever plucker tool directory is needed. 
wxString get_plucker_directory( long directory_name )
{   
    wxString    directory; 
    bool        pluckerhome_exists;
    
    switch ( directory_name ) {
        case CHANNELS:
#ifdef __WXGTK__
            pluckerhome_exists = wxGetEnv( "PLUCKERHOME", &directory );
            if ( ! pluckerhome_exists )
                directory = wxGetHomeDir() << "/.plucker";

            directory.Append( "/channels" );
#else
            directory = wxGetCwd() << '/' << "channels";
#endif
            break;

        case RESOURCES:
            directory = the_configuration->Read( "/PLUCKER-DESKTOP/resource_dir", _T( "resource" ) );
            break;
            
        case PLUCKERHOME:
#ifdef __WXGTK__
            pluckerhome_exists = wxGetEnv( "PLUCKERHOME", &directory );
            if ( ! pluckerhome_exists )
                directory = wxGetHomeDir() << "/.plucker";
#endif
            break;

        default:
            break;
    }

    return directory;
}

