//----------------------------------------------------------------------------------------
// Name:        editor_dialog.h
// Purpose:     Simple HTML editor dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor
// Licence:     GPL
// RCS-ID:      $Id: exclusion_dialog.h,v 1.6 2001/12/25 17:04:48 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _EXCLUSION_DIALOG_H_
#define _EXCLUSION_DIALOG_H_

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#include "wx/dialog.h"
#include "wx/listctrl.h"                // wxListCtrl
#include "wx/textfile.h"                // wxTextFile
#include "wx/notebook.h"                // wxNotebook

//----------------------------------------------------------------------------------------
// Define a new dialog type
//----------------------------------------------------------------------------------------

class exclusion_dialog : public wxDialog
{
public: 
    void listctrl_init();
    void listctrl_load_rows();
    wxListCtrl* get_selected_listctrl();
    long listctrl_get_selected_item_id();
    void listctrl_save_rows( wxListCtrl* listctrl );
    void listctrl_delete_selected_row();
    long listctrl_add_empty_row() ;
    
    void save_exclusion_file();
    
    void on_extensions_tab_add_button( wxCommandEvent &event );
    void on_extensions_tab_edit_button( wxCommandEvent &event );
    void on_extensions_tab_delete_button( wxCommandEvent &event );
    
    void on_urls_tab_add_button( wxCommandEvent &event );
    void on_urls_tab_edit_button( wxCommandEvent &event );
    void on_urls_tab_delete_button( wxCommandEvent &event );       
    
    void OnPageChanged( wxNotebookEvent &event );
    void on_update_ui_extensions_tab_listctrl( wxUpdateUIEvent &event );
    void on_update_ui_urls_tab_listctrl( wxUpdateUIEvent &event );
    // Override base class functions
    void OnOK( wxCommandEvent &event );
    
    wxString m_channel_section;
    wxString m_exclusion_filename;
    wxTextFile m_textfile;
    
    // Currently selected page [index] of the wxNotebook. Initialized to
    // zero.
    int m_selected_exclusion_notebookpage_index;
    // Whether exclusion file has been changed and needs an update
    bool m_exclusion_file_is_dirty;    
private:
    DECLARE_EVENT_TABLE()
};

//----------------------------------------------------------------------------------------
// External functions and variables
//----------------------------------------------------------------------------------------

extern exclusion_dialog*     the_exclusion_dialog;
void init_a_exclusion_dialog( wxWindow* parent, wxString channel_section );

// Easier code maintenance if want to add/rearrangement of listctrl's columns.
enum {
    EXCLUSION_COLUMN    = 0,
    ACTION_COLUMN,
    PRIORITY_COLUMN
};

#endif  //_PROGRESS_DIALOG_H_

