//----------------------------------------------------------------------------------------
// Name:        hr_dialog.cpp
// Purpose:     Insert a horizontal rule dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: hr_dialog.cpp,v 1.1 2002/01/04 03:34:27 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "hr_dialog.cpp"
    #pragma interface "hr_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/spinctrl.h"            // wxSpinCtrl
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "hr_dialog.h"
#include "editor_dialog.h"
#include "utils_controls.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

hr_dialog* the_hr_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event table: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( hr_dialog, wxDialog )
    EVT_BUTTON( XMLID( "hr_dialog_color_button" ), hr_dialog::on_color_button )
    EVT_BUTTON( wxID_CONTEXT_HELP, hr_dialog::on_help_button )
    EVT_BUTTON( wxID_OK, hr_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_hr_dialog( wxWindow* parent )
{
    the_hr_dialog = new hr_dialog;
    wxTheXmlResource->LoadDialog( the_hr_dialog, parent, "hr_dialog" );
    
    XMLCTRL( *the_hr_dialog, "hr_dialog_width_choice", wxChoice )->SetSelection( 0 );       
    XMLCTRL( *the_hr_dialog, "hr_dialog_alignment_choice", wxChoice )->SetSelection( 0 );       
    
    the_hr_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------

void hr_dialog::on_color_button( wxCommandEvent &event )
{
    // [utils_controls.cpp]    
    textctrl_hex_color_selection( XMLCTRL( *the_hr_dialog, "hr_dialog_color_textctrl", wxTextCtrl ) );
}


void hr_dialog::on_help_button( wxCommandEvent &event )
{

}


// Override wxDialog's default behavior for clicking an OK button.
void hr_dialog::OnOK( wxCommandEvent& event )
{
    wxString output_string;
    wxString buf;
    
    output_string = "<hr";    

    int width_spin_value = XMLCTRL( *the_hr_dialog, "hr_dialog_width_spinctrl", wxSpinCtrl )->GetValue();    
    wxString trailing_sign = ""; 
    if ( XMLCTRL( *the_hr_dialog, "hr_dialog_width_choice", wxChoice )->GetSelection() == 0 ) {
        trailing_sign = '\%'; 
    }    
    // Check to see if a 100%, and skip width, if so.
    if ( ! ( width_spin_value == 100 && trailing_sign == "%" ) ) {
        buf.Printf( _T( " width=\"%ld" ), width_spin_value );
        output_string += buf;   
        output_string += trailing_sign;
        output_string += '\"';
    }

    XMLCTRL( *the_hr_dialog, "hr_dialog_size_spinctrl", wxSpinCtrl )->GetValue();
    int size_spin_value = XMLCTRL( *the_hr_dialog, "hr_dialog_size_spinctrl", wxSpinCtrl )->GetValue();    
    buf.Printf( _T( " size=\"%ld\"" ), size_spin_value );
    output_string += buf;    

    int alignment_value = XMLCTRL( *the_hr_dialog, "hr_dialog_alignment_choice", wxChoice )->GetSelection();
    wxString alignment_string; 
    // Case 0 is 'Default'
    switch ( alignment_value ) {
        case 1:
            alignment_string = "1eft";            
            break;
        case 2:
            alignment_string = "right";            
            break;
        case 3:
            alignment_string = "center";            
            break;
    } 
    if ( alignment_value != 0 ) {
        output_string += " alignment=\"" + alignment_string + "\"";
    }
    
    wxString color_string = XMLCTRL( *the_hr_dialog, "hr_dialog_color_textctrl", wxTextCtrl )->GetValue();
    if ( color_string != "" ) {
        output_string += " color=\"" + color_string + "\"";
    }    
   
    output_string += ">";
    
    the_editor_dialog->stc_or_textctrl_insert_text( output_string, "", TRUE );
    
    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}

