//----------------------------------------------------------------------------------------
// Name:        hyperlink_dialog.cpp
// Purpose:     Insert a hyperlink dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: hyperlink_dialog.cpp,v 1.6 2001/12/29 01:59:09 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "hyperlink_dialog.cpp"
    #pragma interface "hyperlink_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/spinctrl.h"            // wxSpinCtrl
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "hyperlink_dialog.h"
#include "editor_dialog.h"
#include "showcase_dialog.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

hyperlink_dialog* the_hyperlink_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event table: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( hyperlink_dialog, wxDialog )
    EVT_UPDATE_UI( XMLID( "hyperlink_dialog_url_radiobutton" ), hyperlink_dialog::on_update_ui_url_radiobutton )
    EVT_BUTTON( XMLID( "hyperlink_dialog_url_button" ), hyperlink_dialog::on_url_button )
    EVT_UPDATE_UI( XMLID( "hyperlink_dialog_file_radiobutton" ), hyperlink_dialog::on_update_ui_file_radiobutton )

    EVT_UPDATE_UI( XMLID( "hyperlink_dialog_maxdepth_checkbox" ), hyperlink_dialog::on_update_ui_maxdepth_checkbox )
    EVT_UPDATE_UI( XMLID( "hyperlink_dialog_staybelow_checkbox" ), hyperlink_dialog::on_update_ui_staybelow_checkbox )
    EVT_UPDATE_UI( XMLID( "hyperlink_dialog_images_depth_checkbox" ), hyperlink_dialog::on_update_ui_images_depth_checkbox )
    EVT_UPDATE_UI( XMLID( "hyperlink_dialog_images_maximum_width_checkbox" ), hyperlink_dialog::on_update_ui_images_maximum_width_checkbox )
    EVT_UPDATE_UI( XMLID( "hyperlink_dialog_images_maximum_height_checkbox" ), hyperlink_dialog::on_update_ui_images_maximum_height_checkbox )

    EVT_BUTTON( wxID_OK, hyperlink_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_hyperlink_dialog( wxWindow* parent )
{
    the_hyperlink_dialog = new hyperlink_dialog;
    wxTheXmlResource->LoadDialog( the_hyperlink_dialog, parent, "hyperlink_dialog" );

    XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_depth_choice", wxChoice )->SetSelection( 1 );       

    the_hyperlink_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------

void hyperlink_dialog::on_update_ui_url_radiobutton( wxUpdateUIEvent &event )
{
    bool enabled;
        
    enabled = XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_url_radiobutton", wxRadioButton )
            ->GetValue();
    XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_url_textctrl", wxTextCtrl )
            ->Enable( enabled );
    XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_url_button", wxButton )
            ->Enable( enabled );
}

void hyperlink_dialog::on_url_button( wxCommandEvent &event )
{
    init_a_showcase_dialog( this );
}

void hyperlink_dialog::on_update_ui_file_radiobutton( wxUpdateUIEvent &event )
{
    bool enabled;
        
    enabled = XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_file_radiobutton", wxRadioButton )
            ->GetValue();
    XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_file_textctrl", wxTextCtrl )
            ->Enable( enabled );
    XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_file_button", wxButton )
            ->Enable( enabled );
}

void hyperlink_dialog::on_update_ui_maxdepth_checkbox( wxUpdateUIEvent &event )
{
    bool enabled;
        
    enabled = XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_maxdepth_checkbox", wxCheckBox )
            ->GetValue();
    XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_maxdepth_spinctrl", wxSpinCtrl )
            ->Enable( enabled );      
}

void hyperlink_dialog::on_update_ui_staybelow_checkbox( wxUpdateUIEvent &event )
{
    bool enabled;
        
    enabled = XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_staybelow_checkbox", wxCheckBox )
            ->GetValue();
    XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_staybelow_textctrl", wxTextCtrl )
            ->Enable( enabled );      
}

void hyperlink_dialog::on_update_ui_images_depth_checkbox( wxUpdateUIEvent &event )
{
    bool enabled;
        
    enabled = XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_depth_checkbox", wxCheckBox )
            ->GetValue();
    XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_depth_choice", wxChoice )
            ->Enable( enabled );      
}

void hyperlink_dialog::on_update_ui_images_maximum_width_checkbox( wxUpdateUIEvent &event )
{
    bool enabled;
        
    enabled = XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_maximum_width_checkbox", wxCheckBox )
            ->GetValue();
    XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_maximum_width_spinctrl", wxSpinCtrl )
            ->Enable( enabled );     
}

void hyperlink_dialog::on_update_ui_images_maximum_height_checkbox( wxUpdateUIEvent &event )
{
    bool enabled;
        
    enabled = XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_maximum_height_checkbox", wxCheckBox )
            ->GetValue();
    XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_maximum_height_spinctrl", wxSpinCtrl )
            ->Enable( enabled );      
}

// Override wxDialog's default behavior for clicking an OK button.
void hyperlink_dialog::OnOK( wxCommandEvent& event )
{
    wxString link_text;
    wxString buf;
    int spin_value;
    
    link_text = "<a href=\"";
      
    if ( XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_url_radiobutton", wxRadioButton )->GetValue() ) {
        link_text +=( XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_url_textctrl", wxTextCtrl )->GetValue() );
    } else {
        link_text +=( XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_file_textctrl", wxTextCtrl )->GetValue() );
    }    
    link_text += "\""; 

    if ( XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_maxdepth_checkbox", wxCheckBox )->GetValue() ) {
        link_text += " maxdepth=\"";
        spin_value = XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_maxdepth_spinctrl", wxSpinCtrl )->GetValue();
        // TODO: Make sure this is the best way to do this. Help says Printf can cause overflow on some ports
        // Note that the _T is requred, or else it won't work.
        buf.Printf( _T( "%d\"" ), spin_value );
        link_text += buf;
     } 
    
    if( XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_stayonhost_checkbox", wxCheckBox )->GetValue() ) {
        link_text += " stayonhost";
    }
    
    if( XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_staybelow_checkbox", wxCheckBox )->GetValue() ) {
        link_text += " staybelow=\"";;
        link_text +=( XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_staybelow_textctrl", wxTextCtrl )->GetValue() );     
        link_text += "\""; ; 
    }
    
    if ( XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_depth_checkbox", wxCheckBox )->GetValue() ) {
        link_text += " bpp=\"";
        // The bpp to use is "2 to the exponent of the index of the choice ctrl"
        spin_value = XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_depth_choice", wxChoice )->GetSelection();
        switch ( spin_value ) {
            case 0:
                spin_value = 0;
                break;
            case 1:
                spin_value = 1;
                break;
            case 2:
                spin_value = 2;
                break;
            case 3:
                spin_value = 4;
                break;
            case 4:
                spin_value = 8;
                break;
            case 5:
                spin_value = 16;
                break;
        } 
        // TODO: Make sure this is the best way to do this. Help says Printf can cause overflow on some ports
        // Note that the _T is requred, or else it won't work.
        buf.Printf( _T( "%d\"" ), spin_value );
        link_text += buf;
     } 
   
     if ( XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_maximum_width_checkbox", wxCheckBox )->GetValue() ) {
        link_text += " maxwidth=\"";
        spin_value = XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_maximum_width_textctrl", wxSpinCtrl )->GetValue();
        // TODO: Make sure this is the best way to do this. Help says Printf can cause overflow on some ports
        // Note that the _T is requred, or else it won't work.
        buf.Printf( _T( "%d\"" ), spin_value );
        link_text += buf;
     } 
  
     if ( XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_maximum_height_checkbox", wxCheckBox )->GetValue() ) {
        link_text += " maxheight=\"";
        spin_value = XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_images_maximum_height_textctrl", wxSpinCtrl )->GetValue();
        // TODO: Make sure this is the best way to do this. Help says Printf can cause overflow on some ports
        // Note that the _T is requred, or else it won't work.
        buf.Printf( _T( "%d\"" ), spin_value );
        link_text += buf;
     }
     
    // Finish off the anchor tag
    link_text += ">";
    link_text +=( XMLCTRL( *the_hyperlink_dialog, "hyperlink_dialog_description_update_uitextctrl", wxTextCtrl )->GetValue() );     
    link_text += "</a>";
    
    the_editor_dialog->stc_or_textctrl_insert_text( link_text, "", TRUE );
    
    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}

