//----------------------------------------------------------------------------------------
// Name:        main_dialog.h
// Purpose:     Main dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: main_dialog.h,v 1.7 2002/01/02 04:57:59 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _MAIN_DIALOG_H_
#define _MAIN_DIALOG_H_

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#include "wx/image.h"
#include "wx/dialog.h"
#include "wx/splitter.h"
#include "wx/dynarray.h"

//----------------------------------------------------------------------------------------
// Define wxArray types
//----------------------------------------------------------------------------------------

// A struct to hold info about each page in the panelflip switching gizmo,
// used in the advanced panel.
struct panelflip_page {
   wxPanel* panel;          // Pointer to the panel for the page
   wxString title;          // Panel's title to display in the sidebar listbox
};

// This WX macro declares a new array type, called panelflip_page_array_type,
// which consists of a number of panelflip_page items.
WX_DEFINE_ARRAY( panelflip_page*, panelflip_page_array_type );

//----------------------------------------------------------------------------------------
// Define a new dialog type
//----------------------------------------------------------------------------------------

class main_dialog : public wxDialog
{
public:
    void set_icon( const wxIcon& icon );
    void on_quit( wxCommandEvent &event );  
    void listctrl_init();
    void listctrl_load_rows();
    wxArrayString listctrl_get_selected_channel_sections();    
   
    void advanced_tab_init();
    void advanced_tab_add_panelflip_page( wxString title, wxString resource_name );
    void advanced_tab_set_panelflip_page( int page_index );
    
    void read_configuration();
    void write_configuration();
    
    void on_close_button( wxCommandEvent &event );  
    
    void on_update_ui_channels_tab_listctrl( wxUpdateUIEvent &event );
    void on_channels_tab_add_button( wxCommandEvent &event );
    void on_channels_tab_configure_button( wxCommandEvent &event );
    void on_channels_tab_delete_button( wxCommandEvent &event );
    void on_channels_tab_update_selected_button( wxCommandEvent &event );
    void on_channels_tab_update_due_button( wxCommandEvent &event );    
    void on_channels_tab_update_all_button( wxCommandEvent &event );   
    
    void on_basic_tab_channel_defaults_button( wxCommandEvent &event );
    void on_update_ui_basic_tab_use_proxy_checkbox( wxUpdateUIEvent &event );
    void on_basic_tab_install_software_button( wxCommandEvent &event );
    
    void on_advanced_tab_section_listbox( wxCommandEvent &event );
    void on_update_ui_advanced_tab_startup_tips_checkbox( wxUpdateUIEvent &event );
    void on_update_ui_advanced_tab_external_editor_radiobutton( wxUpdateUIEvent &event );
    void on_update_ui_advanced_tab_console_radiobutton( wxUpdateUIEvent &event );
    void on_advanced_tab_external_editor_button( wxCommandEvent &event );
    void on_advanced_tab_download_showcase_listings_button( wxCommandEvent &event );
    void on_advanced_tab_showcase_details_button( wxCommandEvent &event );
    void on_advanced_tab_exclusion_lists_button( wxCommandEvent &event );
    void on_advanced_tab_helpers_button( wxCommandEvent &event );
   
    void on_update_ui_autoupdate_tab_after_hours_radiobutton( wxUpdateUIEvent &event );
   
    // An icon for the corner of dialog and application's taskbar button
    wxIcon m_icon;
    
    // Array of panels for advanced tab, and the splitterwindow to switch them,
    panelflip_page_array_type the_advanced_panelflip_array;
    wxSplitterWindow*   the_advanced_splitterwindow;
    wxSize              the_advanced_splitterwindow_size;
    int                 the_advanced_splitterwindow_displayed_page_index;    
private:
    DECLARE_EVENT_TABLE()
};

//----------------------------------------------------------------------------------------
// External functions, variables, and defines
//----------------------------------------------------------------------------------------

extern main_dialog*     the_main_dialog;
void init_a_main_dialog();

// Easier reading if have names instead of numbers for the pages in the listbox_notebook
// panel switching gizmo array on the advanced tab.
// Note these have to match the creation order in advanced_tab_init().
enum {
    GENERAL_PAGE        = 0,
    SPIDERING_PAGE,
    EDITOR_PAGE,
    SHOWCASE_PAGE,
    OS_PAGE,
    APPLICATION_PAGE
};

#endif  //_MAIN_DIALOG_H_

