//----------------------------------------------------------------------------------------
// Name:        ol_dialog.cpp
// Purpose:     Insert an ordered list (ol) dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/01/02
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: ol_dialog.cpp,v 1.2 2002/01/04 08:49:28 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "ol_dialog.cpp"
    #pragma interface "ol_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/spinctrl.h"            // wxSpinCtrl
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "ol_dialog.h"
#include "editor_dialog.h"
#include "utils_controls.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

ol_dialog* the_ol_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event table: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( ol_dialog, wxDialog )
    EVT_UPDATE_UI( XMLID( "ol_dialog_specify_start_checkbox" ), ol_dialog::on_update_ui_specify_start_checkbox )
    EVT_BUTTON( wxID_CONTEXT_HELP, ol_dialog::on_help_button )
    EVT_BUTTON( wxID_OK, ol_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_ol_dialog( wxWindow* parent )
{
    the_ol_dialog = new ol_dialog;
    wxTheXmlResource->LoadDialog( the_ol_dialog, parent, "ol_dialog" );
    
    XMLCTRL( *the_ol_dialog, "ol_dialog_enumeration_choice", wxChoice )->SetSelection( 0 );
    
    the_ol_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------

void ol_dialog::on_update_ui_specify_start_checkbox( wxUpdateUIEvent &event )
{
    bool enabled;
        
    enabled = XMLCTRL( *the_ol_dialog, "ol_dialog_specify_start_checkbox", wxCheckBox )
            ->GetValue();
    XMLCTRL( *the_ol_dialog, "ol_dialog_start_at_spinctrl", wxSpinCtrl )
            ->Enable( enabled );    
}


void ol_dialog::on_help_button( wxCommandEvent &event )
{

}


// Override wxDialog's default behavior for clicking an OK button.
void ol_dialog::OnOK( wxCommandEvent& event )
{
    wxString output_string;
    wxString buf;
    
    output_string = "<ol";    

    bool specify_start = XMLCTRL( *the_ol_dialog, "ol_dialog_specify_start_checkbox", wxCheckBox )->GetValue(); 

    if ( specify_start ) {
        int start_spin_value = XMLCTRL( *the_ol_dialog, "ol_dialog_start_at_spinctrl", wxSpinCtrl )->GetValue(); 
        buf.Printf( _T( " start=\"%ld" ), start_spin_value );
        output_string += buf;   
        output_string += '\"';
    }
        
    int enumeration_value = XMLCTRL( *the_ol_dialog, "ol_dialog_enumeration_choice", wxChoice )->GetSelection();
    wxString enumeration_string; 
    // Case 0 is 'Default'
    switch ( enumeration_value ) {
        case 1:
            enumeration_string = "A";            
            break;
        case 2:
            enumeration_string = "a";            
            break;
        case 3:
            enumeration_string = "I";            
            break;
        case 4:
            enumeration_string = "i";            
            break;
    } 
    if ( enumeration_value != 0 ) {
        output_string += " type=\"" + enumeration_string + "\"";
    }
    
    bool compact = XMLCTRL( *the_ol_dialog, "ol_dialog_compact_checkbox", wxCheckBox )->GetValue(); 
    if ( compact ) {
        output_string += " compact";
    }
    
    output_string += ">";
    
    the_editor_dialog->stc_or_textctrl_insert_text( output_string, "</ol>", TRUE );
    
    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}

