//----------------------------------------------------------------------------------------
// Name:        progress_dialog.cpp
// Purpose:     Plucking channel progress dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: progress_dialog.cpp,v 1.3 2001/11/26 20:09:01 nordstrom Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "progress_dialog.cpp"
    #pragma interface "progress_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          //XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "progress_dialog.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

progress_dialog* the_progress_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event table: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE(progress_dialog, wxDialog)
    EVT_BUTTON( XMLID( "progress_dialog_stop_button" ), progress_dialog::on_stop_button )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Main dialog non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_progress_dialog( wxWindow* parent )
{
    the_progress_dialog = new progress_dialog;
    wxTheXmlResource->LoadDialog( the_progress_dialog, parent, "progress_dialog" );

    // Disable the textctrl so can't type in there and signal that it is read only.
    // Why does this command not work, says no matching function for wxTextCtrl, 
    // but should inherit from window, and is also in the controls example?
    // XMLCTRL( *the_progress_dialog, "progress_dialog_textctrl", wxTextCtrl )->Enabled( FALSE );
        
    the_progress_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------

void progress_dialog::on_stop_button( wxCommandEvent &event )
{
    Show( FALSE );
}

