//----------------------------------------------------------------------------------------
// Name:        plkrdesk.cpp
// Purpose:     Splashscreen
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: splashscreen.cpp,v 1.5 2001/12/08 01:26:49 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "splashscreen.cpp"
    #pragma interface "splashscreen.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/image.h"               // wxImage
#include "wx/splash.h"              // wxSplashScreen
// ---------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
#include "splashscreen.h"
#include "configuration.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

wxSplashScreen* the_splashscreen = NULL;

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void show_splashscreen()
{
    // If configuration file says to display the splashscreen, then show one.
    if ( (bool) the_configuration->Read( "/PLUCKER-DESKTOP/show_splashscreen", 1L ) ) {
    
        wxString splash_image;

        splash_image = get_plucker_directory( RESOURCES ) << "/graphics_misc/splash.png";

        wxBitmap bitmap;
        
        wxLogDebug( "Displaying splashscreen" );
        
        if ( bitmap.LoadFile( splash_image, wxBITMAP_TYPE_PNG ) )
            {   // Generate a splash. NO_TIMEOUT kind, since we will destroy it ourselves
                the_splashscreen = new wxSplashScreen
                    ( bitmap, wxSPLASH_CENTRE_ON_SCREEN|wxSPLASH_NO_TIMEOUT,
                      50000, NULL, -1, wxDefaultPosition, wxDefaultSize,
                      wxSIMPLE_BORDER/*|wxSTAY_ON_TOP*/ );
            }
        // Yield control to pending messages in the windowing system
        wxYield();
        
    }
}

void destroy_splashscreen()
{
    if ( (bool) the_configuration->Read( "/PLUCKER-DESKTOP/show_splashscreen", 1L ) ) {
        // Destroy the splashscreen. Calls a Destroy(), which
        // is the safer way than "delete" to remove frame objects.
        if ( the_splashscreen ) {
            wxLogDebug( "About to destroy splashscreen" );
            the_splashscreen->~wxSplashScreen();
            //the_splashscreen->wxWindow::Destroy();
            wxLogDebug( "Destroyed splashscreen" );    
        }
    }
}

