//----------------------------------------------------------------------------------------
// Name:        startup_tips.cpp
// Purpose:     Provides 'Did you know' tips on application startup
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/12/05
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: startup_tips.cpp,v 1.1 2001/12/08 01:26:49 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "startup_tips.cpp"
    #pragma interface "startup_tips.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/tipdlg.h"                  // wxTipProvider and related
#include "wx/textfile.h"                // wxTextFile

// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"              // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "startup_tips.h"
#include "configuration.h"
#include "main_dialog.h"

// ---------------------------------------------------------------------------------------
// Internal constants
// ---------------------------------------------------------------------------------------

// Choices in the main dialog advanced panel for the type of tips to show.
enum {
    PLUCKER_BASIC_TIPS      = 0,
    PLUCKER_ADVANCED_TIPS,
    RUBBER_CHICKEN_TRIVIA                
};

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void show_startup_tips()
{
    // If prefs say don't user doesn't want to display tips, then just abort here.
    if ( ! (bool) the_configuration->Read( "/PLUCKER-DESKTOP/show_startup_tips", 1L ) ) {
        return;
    }
    
// Allows people compiling, to remove startup tips functionality if a problem on the platform.
#if wxUSE_STARTUP_TIPS

    wxString tips_textfile_name;        // Text filename to use as source of tips
    wxString tips_path;                 // Directory + filename of the source tips file
    long startup_tips_type;             // Pref as read from config, about which tips to use
    size_t last_tip_shown;              // Stores last tip shown, enabling next one to be read
    
    // Look in config settings and see what type of strings to show.          
    startup_tips_type = the_configuration->Read( "/PLUCKER-DESKTOP/startup_tips_type", 0L );
    switch ( startup_tips_type ) {
        case PLUCKER_BASIC_TIPS:
            tips_textfile_name = "plucker_basic_tips.txt";
            break;
        case PLUCKER_ADVANCED_TIPS:
            tips_textfile_name = "plucker_advanced_tips.txt";
            break;
        case RUBBER_CHICKEN_TRIVIA:
            tips_textfile_name = "rubber_chicken_trivia.txt";
            break;
        default:
            wxLogDebug ( "Error: no tips files found" );
            return;
            break;
    }        
     
    tips_path = get_plucker_directory( RESOURCES ) << "/strings_tips/" << tips_textfile_name;
    
    // Read the last tip shown from the configuration file, so know where left off last day.    
    last_tip_shown = (size_t) the_configuration->Read( "/PLUCKER-DESKTOP/startup_tips_last_tip_shown", 0L );
    
    // We have the ability to use different tip files, which have different number of lines, so 
    // after changing the type of tips file, we are left with a last_tip_shown value greater than
    // the number of tips available in the new textfile. Therefore, do a check to see that the 
    // last_tip_shown isn't higher than number of lines.
    wxTextFile the_tips_textfile( tips_path );
    the_tips_textfile.Open();    
    
    size_t tips_textfile_linecount = the_tips_textfile.GetLineCount();    
    if (  tips_textfile_linecount < last_tip_shown ) {
        last_tip_shown = 0;
    }    
    
    the_tips_textfile.Close();

    // Create a tip provider object and initialize it with the correct starting tip
    wxTipProvider *the_tip_provider = wxCreateFileTipProvider( tips_path, last_tip_shown );

    // Display the tip window. Returns the value of the 'show next time' checkbox,
    // telling whether or not they want these to display on startup in the future.
    bool show_startup_tips = wxShowTip( the_main_dialog, the_tip_provider );
    
    // If the showtips checkbox is different to what the config says, then update the
    // cofigurations. Also update the checkbox on the main dialog's advanced tab.
    if ( show_startup_tips != the_configuration->Read( "/PLUCKER-DESKTOP/show_startup_tips", 0L ) != 0 ) {    
        
        the_configuration->Write( "/PLUCKER-DESKTOP/show_startup_tips",
                                  show_startup_tips );
                            
        XMLCTRL( *(the_main_dialog->the_advanced_panelflip_array[ GENERAL_PAGE ]->panel),
                "main_dialog_advanced_tab_startup_tips_checkbox", wxCheckBox )
                ->SetValue( show_startup_tips );                      
    }

    // Write number of last tip shown so know what to show next time.
    the_configuration->Write("/PLUCKER-DESKTOP/startup_tips_last_tip_shown",
                            (long) the_tip_provider->GetCurrentTip() );
    
    // Combust the tip provider in unholy flames.                        
    delete the_tip_provider;
    
#endif  //wxUSE_STARTUP_TIPS
}