//----------------------------------------------------------------------------------------
// Name:        utils_controls.h
// Purpose:     Utils for wx Controls
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: utils_controls.h,v 1.2 2002/01/04 03:34:27 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _UTILS_CONTROLS_H_
#define _UTILS_CONTROLS_H_

#include "wx/splitter.h"            // wxSplitterWindow

//----------------------------------------------------------------------------------------
// External functions and variables
//----------------------------------------------------------------------------------------

// Fixes a wxSplitterWindow that has its sash position out of range. Returns whether it 
// needed a fix
bool splitterwindow_fix_sash_out_of_range( wxSplitterWindow* splitterwindow );    

// When a "Choose color..." button beside a hex color textctrl is tapped, show
// a color dialog, initialize to textctrl's previous value if possible, get the
// color, convert to hex, put it back in the list ctrl. Return false if there
// was a problem.
bool textctrl_hex_color_selection ( wxTextCtrl* target_color_textctrl );


// When a "Choose filename..." button beside a filename textctrl is clicked, show
// a filename dialog, initialize to textctrl's previous value if possible, get the
// filename, convert to hex, put it back in the textctrl. Return false if there
// was a problem.
bool textctrl_filename_selection ( wxTextCtrl* target_filename_textctrl, wxString message,                           
                                   wxString default_file, wxString default_directory, 
                                   wxString wildcard, bool allow_multiple, 
                                   wxChar multiple_selection_delimiter );
                                   
// Some defines to go with filename_selection wildcards
#define FILE_DIALOG_WILDCARDS_IMAGES \
    _T( "Images (*.png, *.gif, *.jpg)|*.png;*.gif;*.jpg;*.jpeg|All files (*.*)|*.*|PNG files (*.png)|*.png|GIF files (*.gif)|*.gif|JPG files (*.jpg,*jpeg)|*.jpg;*.jpeg" )
#ifdef __WXMSW__
    #define FILE_DIALOG_WILDCARDS_EXECUTABLES  _T( "Programs (*.exe)|*.exe" )
#else    
    #define FILE_DIALOG_WILDCARDS_EXECUTABLES  _T( "Programs (*.*)|*.*" )
#endif

#endif  //_UTILS_CONTROLS_H_

