//----------------------------------------------------------------------------------------
// Name:        utils_datetime.h
// Purpose:     Utils for date and time
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/12/28
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: utils_datetime.h,v 1.3 2002/01/02 01:20:39 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _UTILS_DATETIME_H_
#define _UTILS_DATETIME_H_

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------
#include "wx/datetime.h"

//----------------------------------------------------------------------------------------
// External functions and variables
//----------------------------------------------------------------------------------------

// Downloads a url to a local file. Returns true if successful, false if error
bool download_url_to_local_file( wxString remote_url, wxString local_filename );     

// Takes a string of an RFC datetime and converts it to a wxDateTime object
wxDateTime rfc_string_to_datetime( wxString input_rfc_string );
// Takes a wxDateTime string and converts it to a an RFC datetime
wxString datetime_to_rfc_string( wxDateTime input_datetime );

// Takes a string of an RFC time and converts it to a wxDateTime object
wxDateTime rfc_string_to_time( wxString input_rfc_string );
// Takes a wxDateTime string and converts it to a an RFC time
wxString time_to_rfc_string( wxDateTime input_time );

wxTimeSpan get_timezone_offset( wxDateTime input_datetime );
wxTimeSpan get_timezone_offset();
wxDateTime get_current_datetime();
wxDateTime to_timezone_corrected( wxDateTime input_datetime );

#endif  //_UTILS_DATETIME_H_

