//----------------------------------------------------------------------------------------
// Name:        utils_string.h
// Purpose:     Utils for String management and conversion
// Author:      Robert O'Connor
// Modified by:
// Created:     2002/01/01
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: utils_string.h,v 1.3 2002/01/04 03:34:27 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _UTILS_STRING_H_
#define _UTILS_STRING_H_

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------
#include "wx/datetime.h"

//----------------------------------------------------------------------------------------
// External functions and variables
//----------------------------------------------------------------------------------------

// Converts a wxString to a wxArrayInt, based on the delimiter. 
void string_to_arrayint( wxString input_string, wxChar delimiter, wxArrayInt *output_arrayint,
                             bool ignore_trailing_delimiter );
                             
// Converts a wxString to a wxArrayString, based on the delimiter. 
void string_to_arraystring( wxString input_string, wxChar delimiter, wxArrayString *output_arraystring,
                             bool ignore_trailing_delimiter );
                             
// Takes a wxColor type and converts it to a string like '#ffffff', ( with a preceeding # )  
// suitable for putting into an html page      
wxString color_to_hex_string( wxColor input_color );

// Takes a hex color string of the form  '#ffffff', ( with a preceeding # ) and 
// converts it to a wxColor string
wxColor hex_string_to_color( wxString input_string );

// Checks to see whether the string is a valid hex color string of the form  '#ffffff', 
// ( with a preceeding # )
bool is_valid_hex_color_string ( wxString input_string );

#endif  //_UTILS_STRING_H_

