#
# $Id: plucker.spec,v 1.2 2001/11/27 18:24:01 nordstrom Exp $
#
# Spec file for Plucker
#
# Copyright (c) 2001, Michael Nordstrm
#
# This file is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

Name: plucker
Version: @@VERSION@@
Release: 1
Group: None
Summary: Offline HTML reading for Palm devices
License: GPL
URL: http://www.plkr.org/
Source: plucker-%{version}.tar.bz2
Source1: plucker_bin-%{version}.tar.bz2
Requires: python
BuildRoot: %{_tmppath}/plucker-%{version}-root

%description
Plucker increase the utility of your handheld device by letting you view
web pages and any document that can be converted to HTML or text. Plucker
has many advanced features including the ability to read web pages with
embedded images, an advanced find function, the ability to open an e-mail
form when tapping on mail-links in web documents, an impressive compression
ratio for the documents and an open, documented format. It can also be
customized for your specific needs.


%prep


%setup -q
# instead of building the viewer app, ZLib library, and
# the docs we use the prebuilt ones
tar -xIf %{_sourcedir}/plucker_bin-%{version}.tar.bz2
cp -r plucker-%{version}/viewer/* viewer/
cp -r plucker-%{version}/docs/* docs/


%build
./configure \
    --disable-palmosbuild \
    --disable-docbuild \
    --prefix=/usr \
    --mandir=%{_mandir} \
    --with-docdir=%{_datadir}/doc/packages/plucker

make


%install
rm -rf %{buildroot}
mkdir %{buildroot}

make DESTDIR=%{buildroot} install

%define PyPluckerDir %{_libdir}/python2.0/site-packages/PyPlucker
ln -s %{PyPluckerDir}/Spider.py  %{buildroot}/usr/bin/plucker-build
ln -s %{PyPluckerDir}/PluckerDocs.py %{buildroot}/usr/bin/plucker-decode
ln -s %{PyPluckerDir}/PluckerDecode.py %{buildroot}/usr/bin/plucker-dump
ln -s %{PyPluckerDir}/pluck-comics.py %{buildroot}/usr/bin/pluck-comics


%clean
rm -rf %{buildroot}


%files
%doc /usr/share/doc/packages/plucker/
%{_mandir}/man1/plucker-build*
%{_mandir}/man1/plucker-decode*
%{_mandir}/man1/plucker-dump*
%{_mandir}/man1/plucker-setup*
%{_mandir}/man1/pluck-comics*
%{_bindir}/plucker-build
%{_bindir}/plucker-decode
%{_bindir}/plucker-dump
%{_bindir}/plucker-setup
%{_bindir}/plucker-desktop
%{_bindir}/pluck-comics
%{_libdir}/python2.*/site-packages/PyPlucker
%{_datadir}/plucker


%changelog -n plucker
* Sun Jul 22 2001 - micke@sslug.dk
- added version tag that will be set when the package is built

* Sat Jul 21 2001 - micke@sslug.dk
- moved the pluck-comics files inside the Plucker data dir

* Sat Jul 14 2001 - micke@sslug.dk
- initial version

