/*
 * $Id: anchor.h,v 1.21 2001/11/26 20:09:01 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_ANCHOR_H
#define __PLUCKER_ANCHOR_H

#include "viewer.h"
#include "util.h"


typedef enum {
    ANCHOR_UNUSED       = 0,
    ANCHOR_SELECTED     = 1,
    ANCHOR_UNSELECTED   = 2,
    ANCHOR_LIMBO        = 3
} AnchorStateType;


Int16 FindVisibleAnchor( const Int16 x, const Int16 y ) PLKRDB_SECTION;
Int16 GetVisibleImage( const Int16 index ) PLKRDB_SECTION;
Int16 GetVisibleOffset( const Int16 index ) PLKRDB_SECTION;
Int16 GetVisibleReference( const Int16 index ) PLKRDB_SECTION;
RectangleType GetVisibleImagePosition( const Int16 index ) PLKRDB_SECTION;
void AddImageAnchor( const TextContext* tContext, const Int16 height,
        const Int16 image ) PLKRDB_SECTION;
void AdjustVisibleAnchors( const Int16 adjustment ) PLKRDB_SECTION;
void ClearVisibleAnchors( void ) PLKRDB_SECTION;
void ContinueAnchor( const TextContext* tContext ) PLKRDB_SECTION;
void HighlightAnchor( const Int16 control, const AnchorStateType state ) PLKRDB_SECTION;
void RestartAnchor( const TextContext* tContext, const Int16 height ) PLKRDB_SECTION;
void StartAnchor( const TextContext* tContext, const Int16 reference,
        const Int16 offset, const Int16 image ) PLKRDB_SECTION;
void StopAnchor( const TextContext* tContext, const Int16 height ) PLKRDB_SECTION;
void StopImageAnchor( TextContext* tContext, const Int16 height,
        const Int16 width ) PLKRDB_SECTION;

#endif
