/*
 * $Id: resourceids.h,v 1.61 2001/11/26 20:09:02 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

/*
 * Be careful with this file - it's used by things other than cpp.
 * 
 * Control bitmaps MUST have ID = 1000 + control ID
 * 
 */

/* Fonts */
#define narrowFont              128
#define narrowFontID            1000
#define narrowFixedFont         129
#define narrowFixedFontID       1001

/* Control IDs */
#define HOMECONTROL             0
#define LEFTCONTROL             1
#define RIGHTCONTROL            2
#define LIBRARYCONTROL          3
#define FINDCONTROL             4
#define AGAINCONTROL            5
#define MENUCONTROL             6
#define OFFSETCONTROL           7
#define BOOKMARKCONTROL         8
#define AUTOSCROLLSTARTCONTROL  9
#define AUTOSCROLLSTOPCONTROL   10
#define AUTOSCROLLINCRCONTROL   11
#define AUTOSCROLLDECRCONTROL    12

/* Control bitmaps */
#define bmpHome                 1000
#define bmpLeft                 1001
#define bmpRight                1002
#define bmpDbase                1003
#define bmpFind                 1004
#define bmpAgain                1005
#define bmpMenu                 1006
/* NOT USED                     1007 */
#define bmpBookmark             1008
#define bmpAutoscrollStart      1009
#define bmpAutoscrollStop       1010
#define bmpAutoscrollIncr       1011
#define bmpAutoscrollDecr       1012 

/* Other bitmaps */
#define bmpWait                 2000
#define bmpChicken              2001
#define bmpMode1                2002
#define bmpMode2                2003
#define bmpMode3                2004
#define bmpBar                  2005
#define bmpShortBar             2006
#define bmpDoc                  2007
#define bmpSettings             2008
#define bmpTop                  2009
#define bmpBottom               2010
#define bmpTapAction            2011
#define bmpBtnAction            2012
#define bmpGestureUp            2013
#define bmpGestureRight         2014
#define bmpGestureDown          2015
#define bmpGestureLeft          2016
#define bmpGestureTap           2017

/* Forms */
#define frmMainTop              3000
#define frmMainBottom           3001
#define frmMainNone             3002
#define frmMainScrollBar        3003
#define frmMainPercentPopup     3004
#define frmMainPercentList      3005
#define frmMainBookmarkList     3006
#define frmMainImageDialog      3007
#define frmMainImageDialogPopup 3008

#define frmAbout                3100
#define frmAboutOK              3101

#define frmPrefs                    3300
#define frmPrefsOK                  3301
#define frmPrefsCancel              3302
#define frmPrefsMenuHack            3303
#define frmPrefsStrikethrough       3305
#define frmPrefsScrollbarPopup      3306
#define frmPrefsScrollbarList       3307
#define frmPrefsShowDate            3308
#define frmPrefsLinkClick           3309
#define frmPrefsScreenDepthPopup    3310
#define frmPrefsScreenDepthList     3311
#define frmPrefsMenuToolbarPopup    3312
#define frmPrefsMenuToolbarList     3313
#define frmPrefsUnderline           3314
#define frmPrefsFontModeList        3315
#define frmPrefsFontModePopup       3316
#define frmPrefsHardKeys            3317

#define frmLibrary              3400
#define frmLibraryTable         3401
#define frmLibraryScrollBar     3402
#define frmLibraryPopup         3403
#define frmLibraryList          3404
#define frmLibraryDetails       3405
#define frmLibraryCategory      3406
#define frmLibraryDate          3407
#define frmLibrarySize          3408
#define frmLibraryHelp          3409
#define frmLibrarySortOrder     3410
#define frmLibrarySortPopup     3411
#define frmLibrarySortList      3412
#define frmRenameDoc            3413
#define frmRenameDocOK          3414
#define frmRenameDocField       3415
#define frmRenameDocCancel      3416

#define frmDetails              3500
#define frmDetailsOK            3501
#define frmDetailsCancel        3502
#define frmDetailsStatusRead    3503
#define frmDetailsStatusUnread  3504
#define frmDetailsShowImages    3505
#define frmDetailsLink          3506
#define frmDetailsCopy          3507

#define frmControl              3600
#define frmControlOK            3601
#define frmControlCancel        3602
/*** DON'T CHANGE ORDER ***/
#define frmControlList1         3603
#define frmControlList2         3604
#define frmControlList3         3605
#define frmControlList4         3606
/*** DON'T CHANGE ORDER ***/
#define frmControlPopup1        3607
#define frmControlPopup2        3608
#define frmControlPopup3        3609
#define frmControlPopup4        3610
#define frmControlMode1         3611
#define frmControlMode2         3612
#define frmControlMode3         3613
#define frmControlLabel1        3614
#define frmControlLabel2        3615
#define frmControlLabel3        3616
#define frmControlLabel4        3617
#define frmControlMsg1          3618
#define frmControlMsg2          3619
#define frmControlMsg3          3620
#define frmControlMsg4          3621

#define frmSearch               3700
#define frmSearchOK             3701
#define frmSearchField          3702
#define frmSearchCancel         3703
#define frmSearchList           3704
#define frmSearchPopup          3705
#define frmSearchCaseless       3706
#define frmSearchHistory        3707
#define frmSearchHistoryList    3708
#define frmResult               3709
#define frmResultStop           3710
#define frmResultCancel         3711
#define frmResultFindMore       3712
#define frmResultStatus         3713

#define frmCategory             3800
#define frmCatOK                3801
#define frmCatCancel            3802
#define frmCatAll               3803
#define frmCatNone              3804
#define frmCat1                 3805
#define frmCat2                 3806
#define frmCat3                 3807
#define frmCat4                 3808
#define frmCat5                 3809
#define frmCat6                 3810
#define frmCat7                 3811
#define frmCat8                 3812
#define frmCat9                 3813
#define frmCat10                3814
#define frmCat11                3815
#define frmCat12                3816
#define frmCat13                3817
#define frmCat14                3818
#define frmCat15                3819
#define frmCat16                3820
#define frmCatOpen1             3821
#define frmCatOpen2             3822
#define frmCatOpen3             3823
#define frmCatOpen4             3824
#define frmCatOpen5             3825
#define frmCatOpen6             3826
#define frmCatOpen7             3827
#define frmCatOpen8             3828
#define frmCatOpen9             3829
#define frmCatOpen10            3830
#define frmCatOpen11            3831
#define frmCatOpen12            3832
#define frmCatOpen13            3833
#define frmCatOpen14            3834
#define frmCatOpen15            3835
#define frmCatOpen16            3836
#define frmCatMultiple          3837
#define frmCatList              3838
#define frmCatPopup             3839
#define frmCatAND               3840
#define frmCatOR                3841
#define frmNewCategory          3842
#define frmNewCatOK             3843
#define frmNewCatCancel         3844
#define frmNewCatName           3845
#define frmInitCategory         3846
#define frmSortDoc              3847

#define frmEmail                3900
#define frmEmailTo              3901
#define frmEmailCc              3902
#define frmEmailSubject         3903
#define frmEmailMessage         3904
#define frmEmailSend            3905
#define frmEmailCancel          3906
#define frmEmailToArrow         3907
#define frmEmailCcArrow         3908
#define frmEmailSubjectArrow    3909
#define frmEmailScrollBar       3910
#define frmEmailToLabel         3911
#define frmEmailCcLabel         3912
#define frmEmailSubjectLabel    3913

#define frmAddBookmark          4000
#define frmAddBookmarkAdd       4001
#define frmAddBookmarkCancel    4002
#define frmAddBookmarkName      4003
#define frmBookmarks            4004
#define frmBookmarksDone        4005
#define frmBookmarksDelete      4006
#define frmBookmarksList        4007
#define frmBookmarksGo          4008

#define frmExternalLinks        4100
#define frmExternalLinksLink    4101
#define frmExternalLinksBack    4102
#define frmExternalLinksCopy    4103

#define frmButton               4200
#define frmButtonHardKeys       4201
#define frmButtonSelectAction   4202
#define frmButtonActionList     4203
/*** DON'T CHANGE ORDER ***/
#define frmDatebookButton       4204
#define frmAddressButton        4205
#define frmTodoButton           4206
#define frmMemoButton           4207
/*** DON'T CHANGE ORDER ***/
#define frmButtonOK             4208
#define frmButtonCancel         4209

#define frmGesture              4300
#define frmGestureGestures      4301
#define frmGestureSelectAction  4302
#define frmGestureActionList    4303
/*** DON'T CHANGE ORDER ***/
#define frmGestureUp            4304
#define frmGestureRight         4305
#define frmGestureDown          4306
#define frmGestureLeft          4307
#define frmGestureTap           4308
/*** DON'T CHANGE ORDER ***/
#define frmGestureOK            4309
#define frmGestureCancel        4310

#define frmScl                              4400
#define frmSclOK                            4401
#define frmSclCancel                        4402
#define frmSclAutoscrollJumpButton          4403
#define frmSclAutoscrollJumpUpButton        4404
#define frmSclAutoscrollJumpDownButton      4405
#define frmSclAutoscrollModeList            4406
#define frmSclAutoscrollModePopup           4407
#define frmSclAutoscrollDirList             4408
#define frmSclAutoscrollDirPopup            4409
#define frmSclAutoscrollIntervalButton      4410
#define frmSclAutoscrollIntervalUpButton    4411
#define frmSclAutoscrollIntervalDownButton  4412
#define frmSclAutoscrollStayOn              4413


/* Menus */
#define menuMainForm            5000
#define menuLibraryForm         5001

/*** DON'T CHANGE ORDER ***/
#define mGoHome                 5101
#define mGoBack                 5102
#define mGoForward              5103
/*** DON'T CHANGE ORDER ***/
#define mGoSearch               5104
#define mGoSearchAgain          5105
#define mGoAddBookmark          5106
#define mGoBookmarks            5107
#define mGoTop                  5108
#define mGoBottom               5109

#define mViewTopToolbar         5111
#define mViewBottomToolbar      5112
#define mViewNoToolbar          5113
#define mViewAutoscrollStart    5114
#define mViewAutoscrollStop     5115
#define mViewAutoscrollIncr     5116
#define mViewAutoscrollDecr     5117

#define mOptionsAbout           5121
#define mOptionsContact         5122
#define mOptionsPref            5123
#define mOptionsLibrary         5124
#define mOptionsDetails         5125
#define mOptionsControl         5126
#define mOptionsDeleteAll       5127
#define mOptionsButton          5128
#define mOptionsGesture         5129
#define mOptionsScl             5130

#define mDeleteDocument         5131


/* Strings */
#define strPrefsHelp            6000
#define strResultSearching      6001
#define strResultMatches        6002
#define strResultNoMatches      6003
#define strMainAddBookmark      6004
#define strMainViewBookmark     6005
#define strControlHelp          6006
#define strDetailsHelp          6007
#define strExternNoURL          6008
#define strCatHelp              6009
#define strCatDefault           6010
#define strEditCatHelp          6011
#define strLibraryHelp          6012
#define strPrefsStandardFont    6013
#define strPrefsBoldFont        6014
#define strPrefsLargeFont       6015
#define strPrefsLargeBoldFont   6016
#define strButtonHelp           6017
#define strPrefsNarrowFont      6018
#define strGestureHelp          6019
#define strSclHelp              6021
#define strNoDocumentsFound     6022


/* Alerts */
#define warnBrokenDocument      7001
#define infoWrongROMVersion     7002
#define confirmDelete           7003
#define errNoDeleteDoc          7004
#define warnInsufficientMemory  7005
#define confirmEndOfDoc         7006
#define errStringNotFound       7007
#define errBadMailto            7008
#define errAlreadyExists        7009
#define warnLowEmailMem         7010
#define warnNoTo                7011
#define errReadOnly             7012
#define infoTooHighBitDepth     7013
#define warnLowImageMem         7014
#define infoEmptyPatterns       7015
#define warnNoZLibSupport       7016
#define errUnknownType          7017
#define warnImageCompression    7018
#define errNoCategory           7019
#define errCategoryExists       7020
#define confirmMergeCategory    7021
#define confirmDeleteAllDoc     7022
#define errNoDeleteAllDoc       7023
#define infoNoBeamSupport       7024
#define infoCopyProtected       7025
#define warnStayOn              7026


/* Misc */
#define frmShowResult           8001
#define frmJumpToDoc            8002
#define frmUpdateList           8003
#define frmUpdateTable          8004
#define frmViewRecord           8005

