/*
 * $Id: util.h,v 1.24 2001/11/03 14:10:57 robertoconnor Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_UTIL_H
#define __PLUCKER_UTIL_H

#include "viewer.h"

#define NOT_FOUND  -1
#define NO_OFFSET   0

#define OFFSETOF(TYPE, MEMBER) ((UInt32) &((TYPE *)0)->MEMBER)

/*
   Define a "TextContext" which is a drawing context for a string
   (or possibly a series of strings) */
typedef struct {
    Int16           cursorX;
    Int16           cursorY;
    Boolean         writeMode;
    Boolean         activeAnchor;
    RectangleType   italic;
    RectangleType   searchPattern;
    RectangleType   strike;
    Int16           patternOffset;
    RGBColorType    foreColor;   
} TextContext;


void InitializeViewportBoundaries(void) PLKRDB_SECTION;
Boolean DatabaseInCF( LocalID dbID ) PLKRDB_SECTION;
Int16 MaxExtentX(void) PLKRDB_SECTION;
Int16 MaxExtentY(void) PLKRDB_SECTION;
Int16 TopLeftX( void ) PLKRDB_SECTION;
Int16 TopLeftY( void ) PLKRDB_SECTION;
Int16 ExtentX( void ) PLKRDB_SECTION;
Int16 ExtentY( void ) PLKRDB_SECTION;
Int16 GetScrollValue( void ) PLKRDB_SECTION;
void SendAppStopEvent( void ) PLKRDB_SECTION;
void StrikeThrough( const RectangleType* box ) PLKRDB_SECTION;
void TrimText( Char* text, Int16 len ) PLKRDB_SECTION;
void* GetObjectPtr( const Int16 objectID ) PLKRDB_SECTION;

#endif
