/*
 * pdbtohttp.c:
 *
 * Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
 * All rights reserved.
 *
 */

static char rcsid[] = "$Id: pdbtohttp.c,v 1.2 2002/01/18 01:37:29 root Exp $";

/*
 * $Log: pdbtohttp.c,v $
 * Revision 1.2  2002/01/18 01:37:29  root
 * *** empty log message ***
 *
 * Revision 1.1  2002/01/18 01:33:16  root
 * Initial revision
 *
 */

#include <stdio.h>
#include "pi-file.h"

#define SIG 0xea1f154UL

dump_int (unsigned long int i)
{
  unsigned char s[4];
  s[0] = i & 0xff;
  s[1] = (i >> 8) & 0xff;
  s[2] = (i >> 16) & 0xff;
  s[3] = (i >> 24) & 0xff;
  fwrite (s, 1, 4, stdout);
}

dump_short (int i)
{
  unsigned char s[2];
  s[0] = i & 0xff;
  s[1] = (i >> 8) & 0xff;
  fwrite (s, 1, 2, stdout);
}

int
main (int argc, char *argv[])
{
  struct pi_file *pf = pi_file_open (argv[1]);
  int nrecs;
  int i;
  int len = 0;
  int size;
  int cat, attrs;
  unsigned long uid;
  void *buf;

  len += 4;                     /*four byte sig */
  len += 4;                     /*four byte length */

  pi_file_get_entries (pf, &nrecs);
  len += 2;                     /*two byte numrecords */

  for (i = 0; i < nrecs; ++i)
    {
      pi_file_read_record (pf, i, &buf, &size, &attrs, &cat, &uid);
      len += 4;                 /*four byte uid */
      len += 2;                 /*two byte size */
      len += size;              /*data */
    }
  len += 4;                     /*four byte sig */

  printf ("Content-type: application/plucker\n"
          "Content-length: %d\n\n", len);

  dump_int (SIG);
  dump_int (len);
  dump_short (nrecs);

  for (i = 0; i < nrecs; ++i)
    {
      pi_file_read_record (pf, i, &buf, &size, &attrs, &cat, &uid);
      dump_int (uid);
      dump_short (size);
      fwrite (buf, 1, size, stdout);
      fflush (stdout);
    }

  dump_int (SIG);

  pi_file_close (pf);
  return 0;

}
