/****************************************************************************
 *
 *      Copyright (c) 2000, TRG, All Rights Reserved
 *
 *---------------------------------------------------------------------------
 * FileName:
 *              AutoCf.h
 *
 * Description:
 *              AutoCf API definitions.
 *
 * Revision :   1.10 Initial release.
 *
 ****************************************************************************/

#ifndef __AUTOCF_H__
#define __AUTOCF_H__

#include <PalmOS.h>
#include "Trg.h"


#ifndef TRG_CREATOR
#define TRG_CREATOR        'TRG '
#endif

#define AUTOCF_FEATURE_ID  3

#ifndef GBL_PTR_LIST
/*---------------------------------------------------------------------------
 * Global pointer list (snippet from private TRG header file).
 *--------------------------------------------------------------------------*/
#define GBL_PTR_LIST   ((UInt32 ***)0x00000304)  // OEMGlobal2
#define GBL_CF_DB_EXT  7                         // AutoCF Extension

#endif


/*---------------------------------------------------------------------------
 * Error codes.  Database Manager errors could be returned as well.
 *
 * Note: Since AutoCF uses the FfsLib, user should also expect Ffslib error
 *       codes as well.
 *--------------------------------------------------------------------------*/
#define autoCFErrorClass                (appErrorClass | 0x0300)
#define ERR_DB_OPEN                     ((Err)(autoCFErrorClass | 0))


/*---------------------------------------------------------------------------
 * Macro should be used as follows ...
 *
 *  if (AUTOCF_LOADED)
 *      OK to call AutoCF functions
 *  else
        AutoCF not loaded, can not call AutoCF Functions
 *--------------------------------------------------------------------------*/
#define AUTOCF_LOADED  (((*GBL_PTR_LIST)[GBL_CF_DB_EXT]) != 0)


/********************************************************************
 *              AUTOCF API Prototypes
 ********************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#define     trgMinAutoCfFunction       0x300
#define     trgAcfEnable               (trgMinAutoCfFunction +  0)
#define     trgAcfDisable              (trgMinAutoCfFunction +  1)
#define     trgAcfIsEnabled            (trgMinAutoCfFunction +  2)
#define     trgAcfIsCfDatabase         (trgMinAutoCfFunction +  3)
#define     trgAcfNumCfDatabases       (trgMinAutoCfFunction +  4)
#define     trgAcfGetCfDatabase        (trgMinAutoCfFunction +  5)
#define     trgAcfGetPath              (trgMinAutoCfFunction +  6)
#define     trgAcfEnableDuringHotSync  (trgMinAutoCfFunction +  7)
#define     trgAcfDisableDuringHotSync (trgMinAutoCfFunction +  8)
#define     trgAcfQuietEnable          (trgMinAutoCfFunction +  9)
#define     trgMaxAutoCfFunction       (trgMinAutoCfFunction +  9)    
                                                         
extern Err AcfEnable(char *path)
                    TRG_TRAP(trgAcfEnable);

extern Err AcfDisable(void)
                    TRG_TRAP(trgAcfDisable);

extern Boolean AcfIsEnabled(void)
                    TRG_TRAP(trgAcfIsEnabled);

extern Boolean AcfIsCfDatabase(LocalID dbID)
                    TRG_TRAP(trgAcfIsCfDatabase);

extern UInt16 AcfNumCfDatabases(void)
                    TRG_TRAP(trgAcfNumCfDatabases);

extern LocalID AcfGetCfDataase(UInt16 index)
                    TRG_TRAP(trgAcfGetCfDatabase);

extern char *AcfGetPath(char *path)
                    TRG_TRAP(trgAcfGetPath);

extern void AcfEnableDuringHotSync(void)
                    TRG_TRAP(trgAcfEnableDuringHotSync);

extern void AcfDisableDuringHotSync(void)
                    TRG_TRAP(trgAcfDisableDuringHotSync);

extern Err AcfQuietEnable(char *path)
                    TRG_TRAP(trgAcfQuietEnable);

#ifdef __cplusplus 
}
#endif


#endif  // __AUTOCF_H__
