#!/bin/sh
#
# pluck.cgi:
#
# Copyright (c) 2002 James McKenzie <james@fishsoup.dhs.org>,
# All rights reserved.
#
# $Id: pluck.cgi,v 1.1 2002/01/18 01:37:43 root Exp root $
#
# $Log: pluck.cgi,v $
# Revision 1.1  2002/01/18 01:37:43  root
# Initial revision
#
# Revision 1.1  2002/01/17 03:33:33  root
# Initial revision
#
#
IFS=
export USER=apache
export HOME=/export/home/httpd
export PATH=/software/bin:$PATH
export LD_LIBRARY_PATH=/software/lib:$LD_LIBRARY_PATH

PDIR=/export/home/httpd/plucker
DDIR=/export/home/httpd/plucked

echo "" >> $PDIR/log

if [ -f "$DDIR/$QUERY_STRING" ]; then
  echo Got "$QUERY_STRING" from cache >> $PDIR/log 
  cat "$DDIR/$QUERY_STRING"
  exit 0
fi


PF=$$
PFL=$PDIR/$PF.pdb

echo Fetching "$QUERY_STRING" >> $PDIR/log 

/software/bin/plucker-build -V 2 --maxwidth=140 --maxheight=130 -P$PDIR -p$PDIR -E$PDIR/exclusionlist.txt -f $PF -N plucker --bpp 8 -M 1 "$QUERY_STRING" >> $PDIR/log  2>&1 

if [ -f $PFL ]; then
  /software/bin/pdbtohttp $PFL
  /bin/rm -f $PFL
else
  echo Status: 404
  echo Content type: text/plain
  echo Content length: 30
  echo ""
  echo 'Error (go and read the logs)'
fi

exit 0
