//----------------------------------------------------------------------------------------
// Name:        blocked_dialog.cpp
// Purpose:     Add/edit a blocked string for exclusion lists dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: blocked_dialog.cpp,v 1.6 2001/12/25 17:04:48 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "blocked_dialog.cpp"
    #pragma interface "blocked_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/spinctrl.h"            // wxSpinCtrl
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "blocked_dialog.h"
#include "exclusion_dialog.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

blocked_dialog* the_blocked_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event table: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( blocked_dialog, wxDialog )
    EVT_BUTTON( wxID_OK, blocked_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_blocked_dialog( wxWindow* parent, wxListCtrl* selected_listctrl, 
                           long selected_item_id )
{
    the_blocked_dialog = new blocked_dialog;
    wxTheXmlResource->LoadDialog( the_blocked_dialog, parent, "blocked_dialog" );
    
    the_blocked_dialog->m_selected_listctrl = selected_listctrl;
    the_blocked_dialog->m_selected_item_id  = selected_item_id;
    
    the_blocked_dialog->controls_init();
    
    the_blocked_dialog->ShowModal();
}


// Initialized the controls, based on the values in the row.
void blocked_dialog::controls_init()
{       
    wxListItem     info;             // To look up the info for the item.
    wxString       exclusion_string; // String extracted from exclusion column
    int            action;           // Int extracted from action column
    wxString       priority_string;  // String extracted from priority column

    // Look up the properties of wxListItem--first thing is to set the id number
    // (m_itemId) to our current item so we know what item we are talking about
    // in the listctrl grid.
    info.m_itemId = m_selected_item_id;
    // Set text mask (don't know why that is here, but seems to be always used).
    info.m_mask = wxLIST_MASK_TEXT;

    // Set the column of the cell to look for information, to the exclsuion column
    info.m_col = EXCLUSION_COLUMN;
    // Get the properties of that cell
    m_selected_listctrl->GetItem( info );
    exclusion_string = info.m_text;
    // Set the value of the text control
    XMLCTRL( *the_blocked_dialog, "blocked_dialog_exclusion_textctrl", wxTextCtrl )
        ->SetValue( exclusion_string );
    
    // Same strategy for the action column. Include is the second option choice
    // (index of 1)
    info.m_col = ACTION_COLUMN;
    m_selected_listctrl->GetItem( info );        
    if ( info.m_text == _T( "Include" ) ) {
        action = 1;
    } else {
        action = 0;
    }
    XMLCTRL( *the_blocked_dialog, "blocked_dialog_action_choice", wxChoice )
                ->SetSelection( action );   
                
    // And same strategy for the priority column
    info.m_col = PRIORITY_COLUMN;
    m_selected_listctrl->GetItem( info );
    priority_string = info.m_text;
    // A method exists to also just set a spinner to a string, not just an int.
    // However, on "Add", can a blank string, so change it to 0 if so.
    if ( priority_string == "" ) {
        priority_string = "0";
    }
    XMLCTRL( *the_blocked_dialog, "blocked_dialog_priority_spinctrl", wxSpinCtrl )
        ->SetValue( priority_string );
}


//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------

// Override wxDialog's default behavior for clicking an OK button.
void blocked_dialog::OnOK( wxCommandEvent& event )
{  
    wxString exclusion_string;
    int action;
    wxString action_string;
    wxString priority;

    exclusion_string = XMLCTRL( *the_blocked_dialog, 
                             "blocked_dialog_exclusion_textctrl", wxTextCtrl )->GetValue();

    // Prevent ending the dialog if the exclusion box is empty.
    if ( exclusion_string == "" ) {
         wxMessageDialog message_dlg( this, _T( "You must enter some text in the \"Item to block\" edit box." ),
                                      _T( "Enter exclusion" ),
                                      wxOK|wxICON_INFORMATION  );
        message_dlg.ShowModal();
        // Abort the OnOK function
        return;                   
    }
    
   (the_blocked_dialog->m_selected_listctrl)->SetItem( the_blocked_dialog->m_selected_item_id, 
                                                          EXCLUSION_COLUMN, exclusion_string );

    action = XMLCTRL( *the_blocked_dialog, "blocked_dialog_action_choice", wxChoice )
                ->GetSelection();                
    // 0 is exclude, 1 is include
    if ( action == 0 ) {
        action_string = _T( "Exclude" );
    } else {
        action_string = _T( "Include" );     
    }                
    ( the_blocked_dialog->m_selected_listctrl )->
                        SetItem( the_blocked_dialog->m_selected_item_id, 
                                 ACTION_COLUMN, action_string );

    priority.Printf( _T( "%d" ), XMLCTRL( *the_blocked_dialog,
                     "blocked_dialog_priority_spinctrl", wxSpinCtrl )->GetValue() );
    the_blocked_dialog->m_selected_listctrl->
                        SetItem( the_blocked_dialog->m_selected_item_id, PRIORITY_COLUMN, priority );
    
    // Mark the blocked dialog as dirty, so know to save it
    the_exclusion_dialog->m_exclusion_file_is_dirty = TRUE;

    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}

