//----------------------------------------------------------------------------------------
// Name:        channel_dialog.h
// Purpose:     Configure channel dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: channel_dialog.h,v 1.5 2001/12/26 06:41:43 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _CHANNEL_DIALOG_H_
#define _CHANNEL_DIALOG_H_

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------
#include "wx/dialog.h"

//----------------------------------------------------------------------------------------
// Define a new dialog type
//----------------------------------------------------------------------------------------

class channel_dialog : public wxDialog
{
public: 
    void read_configuration();
    void write_configuration();
    
    void on_start_tab_url_radiobutton( wxUpdateUIEvent &event );
    void on_start_tab_file_radiobutton( wxUpdateUIEvent &event );
    void on_start_tab_links_radiobutton( wxUpdateUIEvent &event );
        
    void on_start_tab_url_button( wxCommandEvent &event );
    void on_start_tab_file_button( wxCommandEvent &event );
    void on_start_tab_links_button( wxCommandEvent &event );
        
    void on_limits_tab_exclusion_button( wxCommandEvent &event );
    void on_limits_tab_staybelow_checkbox( wxUpdateUIEvent &event );

    void on_images_tab_include_images_checkbox( wxUpdateUIEvent &event );
    void on_images_tab_only_link_radiobutton( wxUpdateUIEvent &event );
    
    void on_output_tab_only_compress_checkbox( wxUpdateUIEvent &event );
    void on_output_tab_category_checkbox( wxUpdateUIEvent &event );
    void on_output_tab_launchable_checkbox( wxUpdateUIEvent &event );
    void on_output_tab_custom_large_icon_checkbox( wxUpdateUIEvent &event );
    void on_output_tab_custom_small_icon_checkbox( wxUpdateUIEvent &event );
    
    void on_output_tab_custom_small_icon_button( wxCommandEvent &event );
    void on_output_tab_custom_large_icon_button( wxCommandEvent &event );
    
    void on_sync_tab_sync_directory_button( wxCommandEvent &event );    
    void on_sync_tab_specify_filename_radiobutton( wxUpdateUIEvent &event );
    void on_sync_tab_command_before_checkbox( wxUpdateUIEvent &event );
    void on_sync_tab_command_after_checkbox( wxUpdateUIEvent &event );

    void on_scheduling_tab_now_button( wxCommandEvent &event );
    
    // Override base class functions.
    void OnOK( wxCommandEvent& event );

    // Member variables
    wxString m_configuration_section;
private:
    DECLARE_EVENT_TABLE()
};

//----------------------------------------------------------------------------------------
// External functions and variables
//----------------------------------------------------------------------------------------
extern channel_dialog*     the_channel_dialog;
void init_a_channel_dialog( wxWindow* parent, wxString configuration_section );

#endif      //_CHANNEL_DIALOG_H_

