//----------------------------------------------------------------------------------------
// Name:        configuration.h
// Purpose:     Handles saving and loading of configuration settings
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor
// Licence:     GPL
// RCS-ID:      $Id: configuration.h,v 1.4 2001/11/28 01:15:36 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _CONFIGURATION_H_
#define _CONFIGURATION_H_

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------
#include "wx/confbase.h"
#include "wx/fileconf.h"

//----------------------------------------------------------------------------------------
// External functions and variables
//----------------------------------------------------------------------------------------

extern wxFileConfig *the_configuration;

void init_configuration();
void finish_configuration();
wxString get_configuration_extension();
wxString get_os_configuration_section();
bool is_channel_configuration_section( wxString section );
wxString get_plucker_directory( long directory_name );

#define NON_CHANNEL_SECTIONS \
        "DEFAULT", "POSIX", "OS2" "WINDOWS", "MACINTOSH", "PLUCKER-DESKTOP", "PLUCKER-DAEMON"
        
// For calling get_plucker_directory
#define CHANNELS        1
#define RESOURCES       2
#define PLUCKERHOME     3

#endif  //_CONFIGURATION_H_

