//----------------------------------------------------------------------------------------
// Name:        editor_dialog.h
// Purpose:     Simple HTML editor dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor
// Licence:     GPL
// RCS-ID:      $Id: editor_dialog.h,v 1.6 2001/12/26 03:46:41 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _EDITOR_DIALOG_H_
#define _EDITOR_DIALOG_H_

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------
#include "setup.h"              // Plucker-Desktop compilation settings:
                                // modify to turn on/off certain code sections 
// ---------------------------------------------------------------------------------------
#if USE_STYLED_TEXT_CONTROL
    #include "wx/stc/stc.h"         // StyledTextControl widget
#endif
// ---------------------------------------------------------------------------------------
#include "wx/dialog.h"

//----------------------------------------------------------------------------------------
// Define a new dialog type
//----------------------------------------------------------------------------------------

class editor_dialog : public wxDialog
{
public:     
    void on_notebook_changing( wxCommandEvent &event );
    
    void on_toolbar_hyperlink_button( wxCommandEvent &event );

    void on_toolbar_mailto_button( wxCommandEvent &event );
    void on_toolbar_bookmark_button( wxCommandEvent &event );
    void on_toolbar_popup_button( wxCommandEvent &event );
    void on_toolbar_paragraph_button( wxCommandEvent &event );
    void on_toolbar_paragraph_left_button( wxCommandEvent &event );    
    void on_toolbar_paragraph_center_button( wxCommandEvent &event ); 
    void on_toolbar_paragraph_right_button( wxCommandEvent &event ); 
    void on_toolbar_paragraph_full_button( wxCommandEvent &event );
    void on_toolbar_break_button( wxCommandEvent &event );
    void on_toolbar_image_button( wxCommandEvent &event );
    void on_toolbar_hr_button( wxCommandEvent &event );
    void on_toolbar_nbsp_button( wxCommandEvent &event );
    void on_toolbar_symbol_button( wxCommandEvent &event );
    
    void on_toolbar_span_button( wxCommandEvent &event );
    void on_toolbar_div_left_button( wxCommandEvent &event );
    void on_toolbar_div_center_button( wxCommandEvent &event );
    void on_toolbar_div_right_button( wxCommandEvent &event );
    void on_toolbar_center_button( wxCommandEvent &event );
    void on_toolbar_quote_button( wxCommandEvent &event );
    void on_toolbar_cite_button( wxCommandEvent &event );
    
    void on_toolbar_font_button( wxCommandEvent &event );
    void on_toolbar_bold_button( wxCommandEvent &event );
    void on_toolbar_strong_button( wxCommandEvent &event );
    void on_toolbar_italic_button( wxCommandEvent &event );
    void on_toolbar_em_button( wxCommandEvent &event );
    void on_toolbar_underline_button( wxCommandEvent &event );
    void on_toolbar_strike_button( wxCommandEvent &event );
    void on_toolbar_preformatted_button( wxCommandEvent &event );
    void on_toolbar_code_button( wxCommandEvent &event );
    void on_toolbar_h1_button( wxCommandEvent &event ); 
    void on_toolbar_h2_button( wxCommandEvent &event );
    void on_toolbar_h3_button( wxCommandEvent &event );
    void on_toolbar_h4_button( wxCommandEvent &event );
    void on_toolbar_h5_button( wxCommandEvent &event );
    void on_toolbar_h6_button( wxCommandEvent &event );
    
    void on_toolbar_table_button( wxCommandEvent &event );
    void on_toolbar_tr_button( wxCommandEvent &event );
    void on_toolbar_th_button( wxCommandEvent &event );
    void on_toolbar_td_button( wxCommandEvent &event );
    
    void on_toolbar_ordered_list_button( wxCommandEvent &event );
    void on_toolbar_unordered_list_button( wxCommandEvent &event );
    void on_toolbar_list_element_button( wxCommandEvent &event );
    void on_toolbar_menu_button( wxCommandEvent &event );
    void on_toolbar_dt_button( wxCommandEvent &event );
    void on_toolbar_dd_button( wxCommandEvent &event );
    void on_toolbar_dl_button( wxCommandEvent &event );
    
    void on_toolbar_html_button( wxCommandEvent &event );
    void on_toolbar_meta_handheldfriendly_button( wxCommandEvent &event );
    void on_toolbar_body_button( wxCommandEvent &event );
    void on_toolbar_comment_button( wxCommandEvent &event );

    // Override base class functions
    void OnOK( wxCommandEvent &event );
    
    // StyledTextCtrl or TextCtrl functions
    void stc_or_textctrl_attach_as_unknown_control();    
    void stc_or_textctrl_init();
    void stc_or_textctrl_load_file( wxString filename );
    void stc_or_textctrl_insert_text( wxString text_to_insert, 
                                      wxString ending_text_to_insert,
                                      bool tag_can_insert_newline );
    void stc_or_textctrl_send_text_to_preview();
    void stc_or_textctrl_save_file();
    
    // Styledtextctrl or a regular textctrl    
#if USE_STYLED_TEXT_CONTROL
    wxStyledTextCtrl*   m_editor_stc; 
#else
    wxTextCtrl*         m_editor_textctrl; 
#endif
    
    // Store the channel's home_url for when time to write the file.
    wxString m_home_url;
private:
    DECLARE_EVENT_TABLE()
};

//----------------------------------------------------------------------------------------
// External functions and variables
//----------------------------------------------------------------------------------------

extern editor_dialog*     the_editor_dialog;
void init_a_editor_dialog( wxWindow* parent, wxString channel_subdirectory );

#endif  //_PROGRESS_DIALOG_H_

