//----------------------------------------------------------------------------------------
// Name:        email_dialog.cpp
// Purpose:     Insert a email dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: email_dialog.cpp,v 1.1 2002/01/04 03:34:27 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "email_dialog.cpp"
    #pragma interface "email_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "email_dialog.h"
#include "editor_dialog.h"
#include "utils_controls.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

email_dialog* the_email_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event table: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( email_dialog, wxDialog )
    EVT_BUTTON( wxID_CONTEXT_HELP, email_dialog::on_help_button )
    EVT_BUTTON( wxID_OK, email_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_email_dialog( wxWindow* parent )
{
    the_email_dialog = new email_dialog;
    wxTheXmlResource->LoadDialog( the_email_dialog, parent, "email_dialog" );

    the_email_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------

void email_dialog::on_help_button( wxCommandEvent &event )
{

}


// Override wxDialog's default behavior for clicking an OK button.
void email_dialog::OnOK( wxCommandEvent& event )
{
    wxString output_string;
    
    output_string = "<a";    

    wxString name_string = XMLCTRL( *the_email_dialog, "email_dialog_address_textctrl", wxTextCtrl )->GetValue();
    output_string += " href=\"mailto:=\"" + name_string + "\">";
   
    wxString description_string = XMLCTRL( *the_email_dialog, "email_dialog_description_textctrl", wxTextCtrl )->GetValue();
    output_string += description_string;
      
    output_string += "</a>";
    
    the_editor_dialog->stc_or_textctrl_insert_text( output_string, "", TRUE );
    
    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}

