//----------------------------------------------------------------------------------------
// Name:        font_dialog.cpp
// Purpose:     Insert an font dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: font_dialog.cpp,v 1.1 2002/01/04 03:34:27 robertoconnor Exp $
//----------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "font_dialog.cpp"
    #pragma interface "font_dialog.cpp"
#endif
// ---------------------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// For all others, include the necessary headers (this file is usually all you
// need because it includes almost all "standard" wxWindows headers)
#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif
// ---------------------------------------------------------------------------------------
#include "wx/xrc/xmlres.h"          // XRC XML resouces
// ---------------------------------------------------------------------------------------
#include "font_dialog.h"
#include "editor_dialog.h"
#include "utils_controls.h"

// ---------------------------------------------------------------------------------------
// Private variables
// ---------------------------------------------------------------------------------------

font_dialog* the_font_dialog = NULL;

// ---------------------------------------------------------------------------------------
// Event font: connect the events to the handler functions to process them
// ---------------------------------------------------------------------------------------

BEGIN_EVENT_TABLE( font_dialog, wxDialog )
    EVT_BUTTON( XMLID( "font_dialog_color_button" ), font_dialog::on_color_button )
    EVT_BUTTON( wxID_CONTEXT_HELP, font_dialog::on_help_button )
    EVT_BUTTON( wxID_OK, font_dialog::OnOK )
END_EVENT_TABLE()

//----------------------------------------------------------------------------------------
// Non-event handler functions
//----------------------------------------------------------------------------------------

void init_a_font_dialog( wxWindow* parent )
{
    the_font_dialog = new font_dialog;
    wxTheXmlResource->LoadDialog( the_font_dialog, parent, "font_dialog" );    
    
    the_font_dialog->ShowModal();
}

//----------------------------------------------------------------------------------------
// Event handlers
//----------------------------------------------------------------------------------------


void font_dialog::on_color_button( wxCommandEvent &event )
{
    // [utils_controls.cpp]    
    textctrl_hex_color_selection( XMLCTRL( *the_font_dialog, "font_dialog_color_textctrl", wxTextCtrl ) );
}


void font_dialog::on_help_button( wxCommandEvent &event )
{

}


// Override wxDialog's default behavior for clicking an OK button.
void font_dialog::OnOK( wxCommandEvent& event )
{
    wxString output_string;
   
    output_string += "<font";       

    wxString color_string = XMLCTRL( *the_font_dialog, "font_dialog_color_textctrl", wxTextCtrl )->GetValue();
    if ( color_string != "" ) {
        output_string += " color=\"" + color_string + "\"";
    }     
    
    output_string += ">\n";
    
    the_editor_dialog->stc_or_textctrl_insert_text( output_string, "</font>", FALSE );
    
    // Get rid of the modal dialog. Not transferring any info from this modal's control
    // to a parent dialog, so don't have to bother with wxWindow::Validate or 
    // wxWindow::TransferDataFromWindow.    
    EndModal( wxID_OK );
}