//----------------------------------------------------------------------------------------
// Name:        hyperlink_dialog.h
// Purpose:     Insert a hyperlink dialog
// Author:      Robert O'Connor
// Modified by:
// Created:     2001/10/20
// Copyright:   (c) Robert O'Connor ( rob@medicalmnemonics.com )
// Licence:     GPL
// RCS-ID:      $Id: hyperlink_dialog.h,v 1.4 2001/12/29 01:59:09 robertoconnor Exp $
//----------------------------------------------------------------------------------------

#ifndef _HYPERLINK_DIALOG_H_
#define _HYPERLINK_DIALOG_H_

// ---------------------------------------------------------------------------------------
// Headers
// ---------------------------------------------------------------------------------------

#include "wx/dialog.h"

//----------------------------------------------------------------------------------------
// Define a new dialog type
//----------------------------------------------------------------------------------------

class hyperlink_dialog : public wxDialog
{
public:      
    void on_update_ui_url_radiobutton( wxUpdateUIEvent &event );  
    void on_url_button( wxCommandEvent &event );  
    void on_update_ui_file_radiobutton( wxUpdateUIEvent &event ); 
    
    void on_update_ui_maxdepth_checkbox( wxUpdateUIEvent &event );
    void on_update_ui_staybelow_checkbox( wxUpdateUIEvent &event );
    void on_update_ui_images_depth_checkbox( wxUpdateUIEvent &event );
    void on_update_ui_images_maximum_width_checkbox( wxUpdateUIEvent &event );
    void on_update_ui_images_maximum_height_checkbox( wxUpdateUIEvent &event );

    //Override base class functions
    void OnOK( wxCommandEvent& event );
private:
    DECLARE_EVENT_TABLE()
};

//----------------------------------------------------------------------------------------
// External functions and variables
//----------------------------------------------------------------------------------------

extern hyperlink_dialog*     the_hyperlink_dialog;
void init_a_hyperlink_dialog( wxWindow* parent );

#endif  //_HYPERLINK_DIALOG_H_

